/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.history;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.xpack.security.InternalClient;
import org.elasticsearch.xpack.watcher.execution.ExecutionState;
import org.elasticsearch.xpack.watcher.history.WatchRecord;
import org.elasticsearch.xpack.watcher.support.Exceptions;
import org.elasticsearch.xpack.watcher.support.init.proxy.WatcherClientProxy;
import org.elasticsearch.xpack.watcher.support.xcontent.WatcherParams;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class HistoryStore
extends AbstractComponent {
    public static final String INDEX_PREFIX = ".watcher-history-";
    public static final String INDEX_PREFIX_WITH_TEMPLATE = ".watcher-history-2-";
    public static final String DOC_TYPE = "watch_record";
    static final DateTimeFormatter indexTimeFormat = DateTimeFormat.forPattern((String)"YYYY.MM.dd");
    private final WatcherClientProxy client;
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock putUpdateLock = this.readWriteLock.readLock();
    private final Lock stopLock = this.readWriteLock.writeLock();
    private final AtomicBoolean started = new AtomicBoolean(false);

    @Inject
    public HistoryStore(Settings settings, InternalClient client) {
        this(settings, new WatcherClientProxy(settings, client));
    }

    public HistoryStore(Settings settings, WatcherClientProxy client) {
        super(settings);
        this.client = client;
    }

    public void start() {
        this.started.set(true);
    }

    public void stop() {
        this.stopLock.lock();
        try {
            this.started.set(false);
        }
        finally {
            this.stopLock.unlock();
        }
    }

    public void put(WatchRecord watchRecord) throws Exception {
        if (!this.started.get()) {
            throw new IllegalStateException("unable to persist watch record history store is not ready");
        }
        String index = HistoryStore.getHistoryIndexNameForTime(watchRecord.triggerEvent().triggeredTime());
        this.putUpdateLock.lock();
        try (XContentBuilder builder = XContentFactory.jsonBuilder();){
            watchRecord.toXContent(builder, (ToXContent.Params)WatcherParams.builder().hideSecrets(true).build());
            IndexRequest request = new IndexRequest(index, DOC_TYPE, watchRecord.id().value()).source(builder).opType(IndexRequest.OpType.CREATE);
            this.client.index(request, (TimeValue)null);
        }
        catch (IOException ioe) {
            throw Exceptions.ioException("failed to persist watch record [{}]", ioe, watchRecord);
        }
        finally {
            this.putUpdateLock.unlock();
        }
    }

    public void forcePut(WatchRecord watchRecord) throws Exception {
        if (!this.started.get()) {
            throw new IllegalStateException("unable to persist watch record history store is not ready");
        }
        String index = HistoryStore.getHistoryIndexNameForTime(watchRecord.triggerEvent().triggeredTime());
        this.putUpdateLock.lock();
        try (XContentBuilder builder = XContentFactory.jsonBuilder();){
            watchRecord.toXContent(builder, (ToXContent.Params)WatcherParams.builder().hideSecrets(true).build());
            IndexRequest request = new IndexRequest(index, DOC_TYPE, watchRecord.id().value()).source(builder).opType(IndexRequest.OpType.CREATE);
            this.client.index(request, (TimeValue)null);
        }
        catch (VersionConflictEngineException vcee) {
            watchRecord = new WatchRecord.MessageWatchRecord(watchRecord, ExecutionState.EXECUTED_MULTIPLE_TIMES, "watch record [{ " + watchRecord.id() + " }] has been stored before, previous state [" + (Object)((Object)watchRecord.state()) + "]");
            IndexRequest request = new IndexRequest(index, DOC_TYPE, watchRecord.id().value()).source(XContentFactory.jsonBuilder().value((Object)watchRecord));
            this.client.index(request, (TimeValue)null);
        }
        catch (IOException ioe) {
            throw Exceptions.ioException("failed to persist watch record [{}]", ioe, watchRecord);
        }
        finally {
            this.putUpdateLock.unlock();
        }
    }

    public static String getHistoryIndexNameForTime(DateTime time) {
        return INDEX_PREFIX_WITH_TEMPLATE + indexTimeFormat.print((ReadableInstant)time);
    }
}

