/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.execution;

import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshResponse;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.xpack.security.InternalClient;
import org.elasticsearch.xpack.watcher.execution.TriggeredWatch;
import org.elasticsearch.xpack.watcher.execution.Wid;
import org.elasticsearch.xpack.watcher.support.Exceptions;
import org.elasticsearch.xpack.watcher.support.init.proxy.WatcherClientProxy;
import org.elasticsearch.xpack.watcher.watch.WatchStoreUtils;

public class TriggeredWatchStore
extends AbstractComponent {
    public static final String INDEX_NAME = ".triggered_watches";
    public static final String DOC_TYPE = "triggered_watch";
    private final int scrollSize;
    private final WatcherClientProxy client;
    private final TimeValue scrollTimeout;
    private final TriggeredWatch.Parser triggeredWatchParser;
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock accessLock = this.readWriteLock.readLock();
    private final Lock stopLock = this.readWriteLock.writeLock();
    private final AtomicBoolean started = new AtomicBoolean(false);

    @Inject
    public TriggeredWatchStore(Settings settings, InternalClient client, TriggeredWatch.Parser triggeredWatchParser) {
        this(settings, new WatcherClientProxy(settings, client), triggeredWatchParser);
    }

    public TriggeredWatchStore(Settings settings, WatcherClientProxy client, TriggeredWatch.Parser triggeredWatchParser) {
        super(settings);
        this.scrollSize = settings.getAsInt("xpack.watcher.execution.scroll.size", Integer.valueOf(100));
        this.client = client;
        this.scrollTimeout = settings.getAsTime("xpack.watcher.execution.scroll.timeout", TimeValue.timeValueSeconds((long)30L));
        this.triggeredWatchParser = triggeredWatchParser;
    }

    public void start() {
        this.started.set(true);
    }

    public boolean validate(ClusterState state) {
        try {
            IndexMetaData indexMetaData = WatchStoreUtils.getConcreteIndex(INDEX_NAME, state.metaData());
            if (indexMetaData.getState() == IndexMetaData.State.CLOSE) {
                this.logger.debug("triggered watch index [{}] is marked as closed, watcher cannot be started", (Object)indexMetaData.getIndex().getName());
                return false;
            }
            return state.routingTable().index(indexMetaData.getIndex()).allPrimaryShardsActive();
        }
        catch (IndexNotFoundException e) {
            return true;
        }
        catch (IllegalStateException e) {
            this.logger.trace(() -> new ParameterizedMessage("error getting index meta data [{}]: ", (Object)INDEX_NAME), (Throwable)e);
            return false;
        }
    }

    public void stop() {
        this.stopLock.lock();
        try {
            this.started.set(false);
        }
        finally {
            this.stopLock.unlock();
        }
    }

    public void put(TriggeredWatch triggeredWatch) throws Exception {
        this.ensureStarted();
        this.accessLock.lock();
        try {
            IndexRequest request = new IndexRequest(INDEX_NAME, DOC_TYPE, triggeredWatch.id().value()).source(XContentFactory.jsonBuilder().value((Object)triggeredWatch)).opType(IndexRequest.OpType.CREATE);
            this.client.index(request, (TimeValue)null);
        }
        catch (IOException e) {
            throw Exceptions.ioException("failed to persist triggered watch [{}]", e, triggeredWatch);
        }
        finally {
            this.accessLock.unlock();
        }
    }

    public void put(TriggeredWatch triggeredWatch, final ActionListener<Boolean> listener) throws Exception {
        this.ensureStarted();
        try {
            IndexRequest request = new IndexRequest(INDEX_NAME, DOC_TYPE, triggeredWatch.id().value()).source(XContentFactory.jsonBuilder().value((Object)triggeredWatch)).opType(IndexRequest.OpType.CREATE);
            this.client.index(request, new ActionListener<IndexResponse>(){

                public void onResponse(IndexResponse response) {
                    listener.onResponse((Object)true);
                }

                public void onFailure(Exception e) {
                    listener.onFailure(e);
                }
            });
        }
        catch (IOException e) {
            throw Exceptions.ioException("failed to persist triggered watch [{}]", e, triggeredWatch);
        }
    }

    public void putAll(final List<TriggeredWatch> triggeredWatches, final ActionListener<BitSet> listener) throws Exception {
        if (triggeredWatches.isEmpty()) {
            listener.onResponse((Object)new BitSet(0));
            return;
        }
        if (triggeredWatches.size() == 1) {
            this.put(triggeredWatches.get(0), new ActionListener<Boolean>(){

                public void onResponse(Boolean success) {
                    BitSet bitSet = new BitSet(1);
                    bitSet.set(0);
                    listener.onResponse((Object)bitSet);
                }

                public void onFailure(Exception e) {
                    listener.onFailure(e);
                }
            });
            return;
        }
        this.ensureStarted();
        try {
            BulkRequest request = new BulkRequest();
            for (TriggeredWatch triggeredWatch : triggeredWatches) {
                IndexRequest indexRequest = new IndexRequest(INDEX_NAME, DOC_TYPE, triggeredWatch.id().value());
                indexRequest.source(XContentFactory.jsonBuilder().value((Object)triggeredWatch));
                indexRequest.opType(IndexRequest.OpType.CREATE);
                request.add(indexRequest);
            }
            this.client.bulk(request, new ActionListener<BulkResponse>(){

                public void onResponse(BulkResponse response) {
                    BitSet successFullSlots = new BitSet(triggeredWatches.size());
                    for (int i = 0; i < response.getItems().length; ++i) {
                        BulkItemResponse itemResponse = response.getItems()[i];
                        if (itemResponse.isFailed()) {
                            TriggeredWatchStore.this.logger.error("could store triggered watch with id [{}], because failed [{}]", (Object)itemResponse.getId(), (Object)itemResponse.getFailureMessage());
                            continue;
                        }
                        successFullSlots.set(i);
                    }
                    listener.onResponse((Object)successFullSlots);
                }

                public void onFailure(Exception e) {
                    listener.onFailure(e);
                }
            });
        }
        catch (IOException e) {
            throw Exceptions.ioException("failed to persist triggered watches", e, new Object[0]);
        }
    }

    public BitSet putAll(List<TriggeredWatch> triggeredWatches) throws Exception {
        this.ensureStarted();
        try {
            BulkRequest request = new BulkRequest();
            for (TriggeredWatch triggeredWatch : triggeredWatches) {
                IndexRequest indexRequest = new IndexRequest(INDEX_NAME, DOC_TYPE, triggeredWatch.id().value());
                indexRequest.source(XContentFactory.jsonBuilder().value((Object)triggeredWatch));
                indexRequest.opType(IndexRequest.OpType.CREATE);
                request.add(indexRequest);
            }
            BulkResponse response = this.client.bulk(request, (TimeValue)null);
            BitSet successFullSlots = new BitSet(triggeredWatches.size());
            for (int i = 0; i < response.getItems().length; ++i) {
                BulkItemResponse itemResponse = response.getItems()[i];
                if (itemResponse.isFailed()) {
                    this.logger.error("could store triggered watch with id [{}], because failed [{}]", (Object)itemResponse.getId(), (Object)itemResponse.getFailureMessage());
                    continue;
                }
                successFullSlots.set(i);
            }
            return successFullSlots;
        }
        catch (IOException e) {
            throw Exceptions.ioException("failed to persist triggered watches", e, new Object[0]);
        }
    }

    public void delete(Wid wid) {
        this.ensureStarted();
        this.accessLock.lock();
        try {
            DeleteRequest request = new DeleteRequest(INDEX_NAME, DOC_TYPE, wid.value());
            this.client.delete(request);
            this.logger.trace("successfully deleted triggered watch with id [{}]", (Object)wid);
        }
        finally {
            this.accessLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<TriggeredWatch> loadTriggeredWatches(ClusterState state) {
        IndexMetaData indexMetaData;
        try {
            indexMetaData = WatchStoreUtils.getConcreteIndex(INDEX_NAME, state.metaData());
        }
        catch (IndexNotFoundException e) {
            return Collections.emptySet();
        }
        if (!state.routingTable().index(indexMetaData.getIndex()).allPrimaryShardsActive()) {
            throw Exceptions.illegalState("not all primary shards of the triggered watches index {} are started", indexMetaData.getIndex());
        }
        int numPrimaryShards = indexMetaData.getNumberOfShards();
        RefreshResponse refreshResponse = this.client.refresh(new RefreshRequest(new String[]{INDEX_NAME}));
        if (refreshResponse.getSuccessfulShards() < numPrimaryShards) {
            throw Exceptions.illegalState("refresh was supposed to run on [{}] shards, but ran on [{}] shards", numPrimaryShards, refreshResponse.getSuccessfulShards());
        }
        SearchRequest searchRequest = this.createScanSearchRequest();
        SearchResponse response = this.client.search(searchRequest, null);
        ArrayList<TriggeredWatch> triggeredWatches = new ArrayList<TriggeredWatch>();
        try {
            if (response.getTotalShards() != response.getSuccessfulShards()) {
                throw Exceptions.illegalState("scan search was supposed to run on [{}] shards, but ran on [{}] shards", numPrimaryShards, response.getSuccessfulShards());
            }
            while (response.getHits().hits().length != 0) {
                for (SearchHit sh : response.getHits()) {
                    String id = sh.getId();
                    try {
                        TriggeredWatch triggeredWatch = this.triggeredWatchParser.parse(id, sh.version(), sh.getSourceRef());
                        this.logger.trace("loaded triggered watch [{}/{}/{}]", (Object)sh.index(), (Object)sh.type(), (Object)sh.id());
                        triggeredWatches.add(triggeredWatch);
                    }
                    catch (Exception e) {
                        this.logger.error(() -> new ParameterizedMessage("couldn't load triggered watch [{}], ignoring it...", (Object)id), (Throwable)e);
                    }
                }
                response = this.client.searchScroll(response.getScrollId(), this.scrollTimeout);
            }
        }
        finally {
            this.client.clearScroll(response.getScrollId());
        }
        this.logger.debug("loaded [{}] triggered watches", (Object)triggeredWatches.size());
        return triggeredWatches;
    }

    private SearchRequest createScanSearchRequest() {
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder().size(this.scrollSize).sort((SortBuilder)SortBuilders.fieldSort((String)"_doc"));
        SearchRequest searchRequest = new SearchRequest(new String[]{INDEX_NAME});
        searchRequest.source(sourceBuilder);
        searchRequest.types(new String[]{DOC_TYPE});
        searchRequest.scroll(this.scrollTimeout);
        searchRequest.preference("_primary");
        return searchRequest;
    }

    private void ensureStarted() {
        if (!this.started.get()) {
            throw Exceptions.illegalState("unable to persist triggered watches, the store is not ready", new Object[0]);
        }
    }
}

