/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.execution;

import java.util.stream.StreamSupport;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xpack.watcher.execution.ExecutionService;
import org.elasticsearch.xpack.watcher.trigger.TriggerEngine;
import org.elasticsearch.xpack.watcher.trigger.TriggerEvent;
import org.elasticsearch.xpack.watcher.trigger.TriggerService;

public class SyncTriggerListener
implements TriggerEngine.Listener {
    private final ExecutionService executionService;
    private final Logger logger;

    @Inject
    public SyncTriggerListener(Settings settings, ExecutionService executionService, TriggerService triggerService) {
        this.logger = Loggers.getLogger(SyncTriggerListener.class, (Settings)settings, (String[])new String[0]);
        this.executionService = executionService;
        triggerService.register(this);
    }

    @Override
    public void triggered(Iterable<TriggerEvent> events) {
        try {
            this.executionService.processEventsSync(events);
        }
        catch (Exception e) {
            this.logger.error(() -> new ParameterizedMessage("failed to process triggered events [{}]", StreamSupport.stream(events.spliterator(), false).toArray(TriggerEvent[]::new)), (Throwable)e);
        }
    }
}

