/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.execution;

import java.util.Locale;

public enum ExecutionPhase {
    AWAITS_EXECUTION(false),
    STARTED(false),
    INPUT(false),
    CONDITION(false),
    WATCH_TRANSFORM(false),
    ACTIONS(false),
    ABORTED(true),
    FINISHED(true);

    private final boolean sealed;

    private ExecutionPhase(boolean sealed) {
        this.sealed = sealed;
    }

    public boolean sealed() {
        return this.sealed;
    }

    public String id() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public static ExecutionPhase resolve(String id) {
        return ExecutionPhase.valueOf(id.toUpperCase(Locale.ROOT));
    }

    public String toString() {
        return this.id();
    }
}

