/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.condition;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.script.CompiledScript;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.xpack.watcher.Watcher;
import org.elasticsearch.xpack.watcher.condition.Condition;
import org.elasticsearch.xpack.watcher.execution.WatchExecutionContext;
import org.elasticsearch.xpack.watcher.support.Exceptions;
import org.elasticsearch.xpack.watcher.support.Variables;

public final class ScriptCondition
extends Condition {
    public static final String TYPE = "script";
    private static final Condition.Result MET = new Condition.Result(null, "script", true);
    private static final Condition.Result UNMET = new Condition.Result(null, "script", false);
    private final ScriptService scriptService;
    private final Script script;

    public ScriptCondition(Script script) {
        super(TYPE);
        this.script = script;
        this.scriptService = null;
    }

    ScriptCondition(Script script, ScriptService scriptService) {
        super(TYPE);
        this.scriptService = scriptService;
        this.script = script;
        scriptService.compile(script, Watcher.SCRIPT_CONTEXT, Collections.emptyMap());
    }

    public Script getScript() {
        return this.script;
    }

    public static ScriptCondition parse(ScriptService scriptService, String watchId, XContentParser parser, boolean upgradeConditionSource, String defaultLegacyScriptLanguage) throws IOException {
        try {
            Script script = upgradeConditionSource ? Script.parse((XContentParser)parser, (ParseFieldMatcher)ParseFieldMatcher.EMPTY, (String)defaultLegacyScriptLanguage) : Script.parse((XContentParser)parser, (ParseFieldMatcher)ParseFieldMatcher.EMPTY);
            return new ScriptCondition(script, scriptService);
        }
        catch (ElasticsearchParseException pe) {
            throw new ElasticsearchParseException("could not parse [{}] condition for watch [{}]. failed to parse script", (Throwable)pe, new Object[]{TYPE, watchId});
        }
    }

    @Override
    public Condition.Result execute(WatchExecutionContext ctx) {
        return this.doExecute(ctx);
    }

    public Condition.Result doExecute(WatchExecutionContext ctx) {
        CompiledScript compiledScript;
        ExecutableScript executable;
        Object value;
        Map<String, Object> parameters = Variables.createCtxModel(ctx, ctx.payload());
        if (this.script.getParams() != null && !this.script.getParams().isEmpty()) {
            parameters.putAll(this.script.getParams());
        }
        if ((value = (executable = this.scriptService.executable(compiledScript = this.scriptService.compile(this.script, Watcher.SCRIPT_CONTEXT, Collections.emptyMap()), parameters)).run()) instanceof Boolean) {
            return (Boolean)value != false ? MET : UNMET;
        }
        throw Exceptions.invalidScript("condition [{}] must return a boolean value (true|false) but instead returned [{}]", this.type(), ctx.watch().id(), this.script, value);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.script.toXContent(builder, params);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScriptCondition condition = (ScriptCondition)o;
        return this.script.equals((Object)condition.script);
    }

    public int hashCode() {
        return this.script.hashCode();
    }
}

