/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.actions;

import java.io.IOException;
import java.util.Locale;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public interface Action
extends ToXContent {
    public String type();

    public static interface Field {
        public static final ParseField REASON = new ParseField("reason", new String[0]);
    }

    public static interface Builder<A extends Action> {
        public A build();
    }

    public static abstract class Result
    implements ToXContent {
        protected final String type;
        protected final Status status;

        protected Result(String type, Status status) {
            this.type = type;
            this.status = status;
        }

        public String type() {
            return this.type;
        }

        public Status status() {
            return this.status;
        }

        public static class ConditionFailed
        extends StoppedResult {
            public ConditionFailed(String type, String reason, Object ... args) {
                super(type, Status.CONDITION_FAILED, reason, args);
            }
        }

        public static class Throttled
        extends StoppedResult {
            public Throttled(String type, String reason) {
                super(type, Status.THROTTLED, reason, new Object[0]);
            }
        }

        public static class Failure
        extends StoppedResult {
            public Failure(String type, String reason, Object ... args) {
                super(type, Status.FAILURE, reason, args);
            }
        }

        public static class StoppedResult
        extends Result {
            private final String reason;

            protected StoppedResult(String type, Status status, String reason, Object ... args) {
                super(type, status);
                this.reason = LoggerMessageFormat.format((String)reason, (Object[])args);
            }

            public String reason() {
                return this.reason;
            }

            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                return builder.field(Field.REASON.getPreferredName(), this.reason);
            }
        }

        public static enum Status implements ToXContent
        {
            SUCCESS,
            FAILURE,
            PARTIAL_FAILURE,
            THROTTLED,
            CONDITION_FAILED,
            SIMULATED;


            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                return builder.value(this.name().toLowerCase(Locale.ROOT));
            }
        }
    }
}

