/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher;

import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.inject.util.Providers;
import org.elasticsearch.xpack.XPackPlugin;
import org.elasticsearch.xpack.watcher.WatcherFeatureSet;
import org.elasticsearch.xpack.watcher.WatcherLifeCycleService;
import org.elasticsearch.xpack.watcher.WatcherService;
import org.elasticsearch.xpack.watcher.support.WatcherIndexTemplateRegistry;

public class WatcherModule
extends AbstractModule {
    private final boolean enabled;
    private final boolean transportClientMode;

    public WatcherModule(boolean enabled, boolean transportClientMode) {
        this.enabled = enabled;
        this.transportClientMode = transportClientMode;
    }

    protected void configure() {
        if (this.transportClientMode) {
            return;
        }
        if (!this.enabled) {
            this.bind(WatcherService.class).toProvider(Providers.of(null));
        } else {
            this.bind(WatcherLifeCycleService.class).asEagerSingleton();
            this.bind(WatcherIndexTemplateRegistry.class).asEagerSingleton();
        }
        XPackPlugin.bindFeatureSet(this.binder(), WatcherFeatureSet.class);
    }
}

