/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.rest.RestRequest;

public interface RestRequestFilter {
    default public RestRequest getFilteredRequest(final RestRequest restRequest) throws IOException {
        final Set<String> fields = this.getFilteredFields();
        if (restRequest.hasContent() && !fields.isEmpty()) {
            return new RestRequest(restRequest.getXContentRegistry(), restRequest.params(), restRequest.path()){
                private BytesReference filteredBytes;
                {
                    super(x0, x1, x2);
                    this.filteredBytes = null;
                }

                public RestRequest.Method method() {
                    return restRequest.method();
                }

                public String uri() {
                    return restRequest.uri();
                }

                public boolean hasContent() {
                    return true;
                }

                public BytesReference content() {
                    if (this.filteredBytes == null) {
                        BytesReference content = restRequest.content();
                        Tuple result = XContentHelper.convertToMap((BytesReference)content, (boolean)true);
                        Map transformedSource = XContentMapValues.filter((Map)((Map)result.v2()), null, (String[])fields.toArray(Strings.EMPTY_ARRAY));
                        try {
                            XContentBuilder xContentBuilder = XContentBuilder.builder((XContent)((XContentType)result.v1()).xContent()).map(transformedSource);
                            this.filteredBytes = xContentBuilder.bytes();
                        }
                        catch (IOException e) {
                            throw new ElasticsearchException("failed to parse request", (Throwable)e, new Object[0]);
                        }
                    }
                    return this.filteredBytes;
                }

                public String header(String name) {
                    return restRequest.header(name);
                }

                public Iterable<Map.Entry<String, String>> headers() {
                    return restRequest.headers();
                }
            };
        }
        return restRequest;
    }

    public Set<String> getFilteredFields();
}

