/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz.accesscontrol;

import java.util.HashSet;
import org.apache.lucene.search.QueryCachingPolicy;
import org.apache.lucene.search.Weight;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.support.broadcast.BroadcastShardRequest;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.cache.query.QueryCache;
import org.elasticsearch.indices.IndicesQueryCache;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.xpack.security.authz.accesscontrol.FieldExtractor;
import org.elasticsearch.xpack.security.authz.accesscontrol.IndicesAccessControl;
import org.elasticsearch.xpack.security.authz.accesscontrol.RequestContext;

public final class OptOutQueryCache
extends AbstractIndexComponent
implements QueryCache {
    final IndicesQueryCache indicesQueryCache;

    public OptOutQueryCache(IndexSettings indexSettings, IndicesQueryCache indicesQueryCache) {
        super(indexSettings);
        this.indicesQueryCache = indicesQueryCache;
    }

    public void close() throws ElasticsearchException {
        this.clear("close");
    }

    public void clear(String reason) {
        this.logger.debug("full cache clear, reason [{}]", (Object)reason);
        this.indicesQueryCache.clearIndex(this.index().getName());
    }

    public Weight doCache(Weight weight, QueryCachingPolicy policy) {
        String indexName;
        RequestContext context = RequestContext.current();
        if (context == null) {
            throw new IllegalStateException("opting out of the query cache. current request can't be found");
        }
        IndicesAccessControl indicesAccessControl = (IndicesAccessControl)context.getThreadContext().getTransient("_indices_permissions");
        if (indicesAccessControl == null) {
            this.logger.debug("opting out of the query cache. current request doesn't hold indices permissions");
            return weight;
        }
        if (context.getRequest() instanceof ShardSearchRequest) {
            indexName = ((ShardSearchRequest)context.getRequest()).shardId().getIndexName();
        } else if (context.getRequest() instanceof BroadcastShardRequest) {
            indexName = ((BroadcastShardRequest)context.getRequest()).shardId().getIndexName();
        } else {
            return weight;
        }
        IndicesAccessControl.IndexAccessControl indexAccessControl = indicesAccessControl.getIndexPermissions(indexName);
        if (indexAccessControl != null && indexAccessControl.getFieldPermissions().hasFieldLevelSecurity()) {
            if (OptOutQueryCache.cachingIsSafe(weight, indexAccessControl)) {
                this.logger.trace("not opting out of the query cache. request for index [{}] is safe to cache", (Object)indexName);
                return this.indicesQueryCache.doCache(weight, policy);
            }
            this.logger.trace("opting out of the query cache. request for index [{}] is unsafe to cache", (Object)indexName);
            return weight;
        }
        this.logger.trace("not opting out of the query cache. request for index [{}] has field level security disabled", (Object)indexName);
        return this.indicesQueryCache.doCache(weight, policy);
    }

    static boolean cachingIsSafe(Weight weight, IndicesAccessControl.IndexAccessControl permissions) {
        HashSet<String> fields = new HashSet<String>();
        try {
            FieldExtractor.extractFields(weight.getQuery(), fields);
        }
        catch (UnsupportedOperationException ok) {
            return false;
        }
        for (String field : fields) {
            if (!field.startsWith("_") && permissions.getFieldPermissions().grantsAccessTo(field)) continue;
            return false;
        }
        return true;
    }
}

