/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz;

import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.util.concurrent.CountDown;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.xpack.security.authc.Authentication;
import org.elasticsearch.xpack.security.authz.AuthorizationService;
import org.elasticsearch.xpack.security.authz.permission.Role;
import org.elasticsearch.xpack.security.support.Automatons;
import org.elasticsearch.xpack.security.user.SystemUser;

public final class AuthorizationUtils {
    private static final Predicate<String> INTERNAL_PREDICATE = Automatons.predicate("internal:*");

    private AuthorizationUtils() {
    }

    public static boolean shouldReplaceUserWithSystem(ThreadContext threadContext, String action) {
        if (!AuthorizationUtils.isInternalAction(action)) {
            return false;
        }
        Authentication authentication = (Authentication)threadContext.getTransient("_xpack_security_authentication");
        if (authentication == null) {
            return true;
        }
        String originatingAction = (String)threadContext.getTransient("_originating_action_name");
        return originatingAction != null && !AuthorizationUtils.isInternalAction(originatingAction);
    }

    private static boolean isInternalAction(String action) {
        return INTERNAL_PREDICATE.test(action);
    }

    public static class AsyncAuthorizer {
        private final ActionListener listener;
        private final BiConsumer<Role, Role> consumer;
        private final Authentication authentication;
        private volatile Role userRoles;
        private volatile Role runAsRoles;
        private CountDown countDown = new CountDown(2);

        public AsyncAuthorizer(Authentication authentication, ActionListener listener, BiConsumer<Role, Role> consumer) {
            this.consumer = consumer;
            this.listener = listener;
            this.authentication = authentication;
        }

        public void authorize(AuthorizationService service) {
            if (SystemUser.is(this.authentication.getUser())) {
                this.setUserRoles(null);
                this.setRunAsRoles(null);
            } else {
                service.roles(this.authentication.getUser(), (ActionListener<Role>)ActionListener.wrap(this::setUserRoles, arg_0 -> ((ActionListener)this.listener).onFailure(arg_0)));
                if (this.authentication.isRunAs()) {
                    assert (this.authentication.getRunAsUser() != null) : "runAs user is null but shouldn't";
                    service.roles(this.authentication.getRunAsUser(), (ActionListener<Role>)ActionListener.wrap(this::setRunAsRoles, arg_0 -> ((ActionListener)this.listener).onFailure(arg_0)));
                } else {
                    this.setRunAsRoles(null);
                }
            }
        }

        private void setUserRoles(Role roles) {
            this.userRoles = roles;
            this.maybeRun();
        }

        private void setRunAsRoles(Role roles) {
            this.runAsRoles = roles;
            this.maybeRun();
        }

        private void maybeRun() {
            if (this.countDown.countDown()) {
                try {
                    this.consumer.accept(this.userRoles, this.runAsRoles);
                }
                catch (Exception e) {
                    this.listener.onFailure(e);
                }
            }
        }
    }
}

