/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.ldap.support;

import com.unboundid.ldap.sdk.AsyncRequestID;
import com.unboundid.ldap.sdk.AsyncSearchResultListener;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.DereferencePolicy;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.LDAPURL;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultListener;
import com.unboundid.ldap.sdk.SearchResultReference;
import com.unboundid.ldap.sdk.SearchScope;
import java.io.Closeable;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.naming.ldap.Rdn;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.ESLoggerFactory;
import org.elasticsearch.common.util.concurrent.CountDown;
import org.elasticsearch.xpack.security.support.Exceptions;

public final class LdapUtils {
    public static final Filter OBJECT_CLASS_PRESENCE_FILTER = Filter.createPresenceFilter((String)"objectClass");

    private LdapUtils() {
    }

    public static DN dn(String dn) {
        try {
            return new DN(dn);
        }
        catch (LDAPException e) {
            throw new IllegalArgumentException("invalid DN [" + dn + "]", e);
        }
    }

    public static String relativeName(DN dn) {
        return dn.getRDNString().split("=")[1].trim();
    }

    public static String escapedRDNValue(String rdn) {
        return Rdn.escapeValue(rdn);
    }

    public static void searchForEntry(LDAPInterface ldap, String baseDN, SearchScope scope, Filter filter, int timeLimitSeconds, ActionListener<SearchResultEntry> listener, String ... attributes) {
        if (ldap instanceof LDAPConnection) {
            LdapUtils.searchForEntry((LDAPConnection)ldap, baseDN, scope, filter, timeLimitSeconds, listener, attributes);
        } else if (ldap instanceof LDAPConnectionPool) {
            LdapUtils.searchForEntry((LDAPConnectionPool)ldap, baseDN, scope, filter, timeLimitSeconds, listener, attributes);
        } else {
            throw new IllegalArgumentException("unsupported LDAPInterface implementation: " + ldap);
        }
    }

    public static void searchForEntry(LDAPConnection ldap, String baseDN, SearchScope scope, Filter filter, int timeLimitSeconds, ActionListener<SearchResultEntry> listener, String ... attributes) {
        SingleEntryListener searchResultListener = new SingleEntryListener(ldap, listener, filter);
        try {
            SearchRequest request = new SearchRequest((SearchResultListener)searchResultListener, baseDN, scope, DereferencePolicy.NEVER, 0, timeLimitSeconds, false, filter, attributes);
            searchResultListener.setSearchRequest(request);
            ldap.asyncSearch(request);
        }
        catch (LDAPException e) {
            listener.onFailure((Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void searchForEntry(LDAPConnectionPool ldap, String baseDN, SearchScope scope, Filter filter, int timeLimitSeconds, ActionListener<SearchResultEntry> listener, String ... attributes) {
        block5: {
            LDAPConnection finalConnection;
            boolean searching = false;
            LDAPConnection ldapConnection = null;
            try {
                finalConnection = ldapConnection = ldap.getConnection();
                LdapUtils.searchForEntry(finalConnection, baseDN, scope, filter, timeLimitSeconds, (ActionListener<SearchResultEntry>)ActionListener.wrap(entry -> {
                    IOUtils.close((Closeable[])new Closeable[]{() -> ldap.releaseConnection(finalConnection)});
                    listener.onResponse(entry);
                }, e -> {
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{() -> ldap.releaseConnection(finalConnection)});
                    listener.onFailure(e);
                }), attributes);
                searching = true;
                if (searching) break block5;
                finalConnection = ldapConnection;
            }
            catch (LDAPException e2) {
                LDAPConnection finalConnection2;
                try {
                    listener.onFailure((Exception)((Object)e2));
                    if (searching) break block5;
                    finalConnection2 = ldapConnection;
                }
                catch (Throwable throwable) {
                    if (!searching) {
                        LDAPConnection finalConnection3 = ldapConnection;
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{() -> ldap.releaseConnection(finalConnection3)});
                    }
                    throw throwable;
                }
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{() -> ldap.releaseConnection(finalConnection3)});
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{() -> ldap.releaseConnection(finalConnection3)});
        }
    }

    public static void search(LDAPInterface ldap, String baseDN, SearchScope scope, Filter filter, int timeLimitSeconds, ActionListener<List<SearchResultEntry>> listener, String ... attributes) {
        if (ldap instanceof LDAPConnection) {
            LdapUtils.search((LDAPConnection)ldap, baseDN, scope, filter, timeLimitSeconds, listener, attributes);
        } else if (ldap instanceof LDAPConnectionPool) {
            LdapUtils.search((LDAPConnectionPool)ldap, baseDN, scope, filter, timeLimitSeconds, listener, attributes);
        } else {
            throw new IllegalArgumentException("unsupported LDAPInterface implementation: " + ldap);
        }
    }

    public static void search(LDAPConnection ldap, String baseDN, SearchScope scope, Filter filter, int timeLimitSeconds, ActionListener<List<SearchResultEntry>> listener, String ... attributes) {
        LdapSearchResultListener searchResultListener = new LdapSearchResultListener(ldap, (asyncRequestID, searchResult) -> listener.onResponse(Collections.unmodifiableList(searchResult.getSearchEntries())), 1);
        try {
            SearchRequest request = new SearchRequest((SearchResultListener)searchResultListener, baseDN, scope, DereferencePolicy.NEVER, 0, timeLimitSeconds, false, filter, attributes);
            searchResultListener.setSearchRequest(request);
            ldap.asyncSearch(request);
        }
        catch (LDAPException e) {
            listener.onFailure((Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void search(LDAPConnectionPool ldap, String baseDN, SearchScope scope, Filter filter, int timeLimitSeconds, ActionListener<List<SearchResultEntry>> listener, String ... attributes) {
        block5: {
            LDAPConnection finalConnection;
            boolean searching = false;
            LDAPConnection ldapConnection = null;
            try {
                finalConnection = ldapConnection = ldap.getConnection();
                LdapSearchResultListener ldapSearchResultListener = new LdapSearchResultListener(ldapConnection, (asyncRequestID, searchResult) -> {
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{() -> ldap.releaseConnection(finalConnection)});
                    listener.onResponse(Collections.unmodifiableList(searchResult.getSearchEntries()));
                }, 1);
                SearchRequest request = new SearchRequest((SearchResultListener)ldapSearchResultListener, baseDN, scope, DereferencePolicy.NEVER, 0, timeLimitSeconds, false, filter, attributes);
                ldapSearchResultListener.setSearchRequest(request);
                finalConnection.asyncSearch(request);
                searching = true;
                if (searching || ldapConnection == null) break block5;
                finalConnection = ldapConnection;
            }
            catch (LDAPException e) {
                LDAPConnection finalConnection2;
                try {
                    listener.onFailure((Exception)((Object)e));
                    if (searching || ldapConnection == null) break block5;
                    finalConnection2 = ldapConnection;
                }
                catch (Throwable throwable) {
                    if (!searching && ldapConnection != null) {
                        LDAPConnection finalConnection3 = ldapConnection;
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{() -> ldap.releaseConnection(finalConnection3)});
                    }
                    throw throwable;
                }
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{() -> ldap.releaseConnection(finalConnection3)});
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{() -> ldap.releaseConnection(finalConnection3)});
        }
    }

    public static Filter createFilter(String filterTemplate, String ... arguments) throws LDAPException {
        return Filter.create((String)new MessageFormat(filterTemplate, Locale.ROOT).format(LdapUtils.encodeFilterValues(arguments), new StringBuffer(), (FieldPosition)null).toString());
    }

    public static String[] attributesToSearchFor(String[] attributes) {
        String[] stringArray;
        if (attributes == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "1.1";
        } else {
            stringArray = attributes;
        }
        return stringArray;
    }

    static String[] encodeFilterValues(String ... arguments) {
        for (int i = 0; i < arguments.length; ++i) {
            arguments[i] = Filter.encodeValue((String)arguments[i]);
        }
        return arguments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void followReferral(LDAPConnection ldapConnection, String urlString, SearchRequest searchRequest, BiConsumer<AsyncRequestID, SearchResult> consumer, int depth, SearchResult originatingResult, AsyncRequestID asyncRequestID) throws LDAPException {
        LDAPURL referralURL = new LDAPURL(urlString);
        String host = referralURL.getHost();
        if (host != null) {
            String requestBaseDN = referralURL.baseDNProvided() ? referralURL.getBaseDN().toString() : searchRequest.getBaseDN();
            SearchScope requestScope = referralURL.scopeProvided() ? referralURL.getScope() : searchRequest.getScope();
            Filter requestFilter = referralURL.filterProvided() ? referralURL.getFilter() : searchRequest.getFilter();
            LDAPConnection referralConn = ldapConnection.getReferralConnector().getReferralConnection(referralURL, ldapConnection);
            LdapSearchResultListener listener = new LdapSearchResultListener(referralConn, (reqId, searchResult) -> {
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{referralConn});
                consumer.accept((AsyncRequestID)reqId, (SearchResult)searchResult);
            }, depth);
            boolean success = false;
            try {
                SearchRequest referralSearchRequest = new SearchRequest((SearchResultListener)listener, searchRequest.getControls(), requestBaseDN, requestScope, searchRequest.getDereferencePolicy(), searchRequest.getSizeLimit(), searchRequest.getTimeLimitSeconds(), searchRequest.typesOnly(), requestFilter, searchRequest.getAttributes());
                listener.setSearchRequest(searchRequest);
                referralConn.asyncSearch(referralSearchRequest);
                return;
            }
            catch (Throwable throwable) {
                if (success) throw throwable;
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{referralConn});
                throw throwable;
            }
        }
        consumer.accept(asyncRequestID, new SearchResult(originatingResult.getMessageID(), ResultCode.UNAVAILABLE, null, null, null, Collections.emptyList(), Collections.emptyList(), 0, 0, null));
    }

    private static class LdapSearchResultListener
    implements AsyncSearchResultListener {
        private static final Logger LOGGER = ESLoggerFactory.getLogger(LdapUtils.class);
        private final List<SearchResultEntry> entryList = new ArrayList<SearchResultEntry>();
        private final List<SearchResultReference> referenceList = new ArrayList<SearchResultReference>();
        protected final SetOnce<SearchRequest> searchRequestRef = new SetOnce();
        private final BiConsumer<AsyncRequestID, SearchResult> consumer;
        private final LDAPConnection ldapConnection;
        private final int depth;

        LdapSearchResultListener(LDAPConnection ldapConnection, BiConsumer<AsyncRequestID, SearchResult> consumer, int depth) {
            this.ldapConnection = ldapConnection;
            this.consumer = consumer;
            this.depth = depth;
        }

        public void searchEntryReturned(SearchResultEntry searchEntry) {
            this.entryList.add(searchEntry);
        }

        public void searchReferenceReturned(SearchResultReference searchReference) {
            this.referenceList.add(searchReference);
        }

        public void searchResultReceived(AsyncRequestID requestID, SearchResult searchResult) {
            Object[] referralUrls = this.referenceList.stream().flatMap(ref -> Arrays.stream(ref.getReferralURLs())).collect(Collectors.toList()).toArray(Strings.EMPTY_ARRAY);
            SearchRequest searchRequest = (SearchRequest)this.searchRequestRef.get();
            if (referralUrls.length == 0 || !searchRequest.followReferrals(this.ldapConnection)) {
                LOGGER.trace("LDAP Search {} => {} ({})", (Object)searchRequest, (Object)searchResult, this.entryList);
                SearchResult resultWithValues = new SearchResult(searchResult.getMessageID(), searchResult.getResultCode(), searchResult.getDiagnosticMessage(), searchResult.getMatchedDN(), (String[])referralUrls, this.entryList, this.referenceList, this.entryList.size(), this.referenceList.size(), searchResult.getResponseControls());
                this.consumer.accept(requestID, resultWithValues);
            } else if (this.depth >= this.ldapConnection.getConnectionOptions().getReferralHopLimit()) {
                LOGGER.trace("Referral limit exceeded {} => {} ({})", (Object)searchRequest, (Object)searchResult, this.entryList);
                SearchResult resultWithValues = new SearchResult(searchResult.getMessageID(), ResultCode.REFERRAL_LIMIT_EXCEEDED, searchResult.getDiagnosticMessage(), searchResult.getMatchedDN(), (String[])referralUrls, this.entryList, this.referenceList, this.entryList.size(), this.referenceList.size(), searchResult.getResponseControls());
                this.consumer.accept(requestID, resultWithValues);
            } else {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("LDAP referred elsewhere {} => {}", (Object)searchRequest, (Object)Arrays.toString(referralUrls));
                }
                CountDown countDown = new CountDown(referralUrls.length);
                ArrayList<Object> referralUrlsList = new ArrayList<Object>(Arrays.asList(referralUrls));
                BiConsumer<AsyncRequestID, SearchResult> referralConsumer = (reqID, innerResult) -> {
                    LdapSearchResultListener ldapSearchResultListener = this;
                    synchronized (ldapSearchResultListener) {
                        if (innerResult.getSearchEntries() != null) {
                            this.entryList.addAll(innerResult.getSearchEntries());
                        }
                        if (innerResult.getSearchReferences() != null) {
                            this.referenceList.addAll(innerResult.getSearchReferences());
                        }
                    }
                    if (countDown.countDown()) {
                        SearchResult resultWithValues = new SearchResult(searchResult.getMessageID(), searchResult.getResultCode(), searchResult.getDiagnosticMessage(), searchResult.getMatchedDN(), referralUrlsList.toArray(Strings.EMPTY_ARRAY), this.entryList, this.referenceList, this.entryList.size(), this.referenceList.size(), searchResult.getResponseControls());
                        this.consumer.accept(requestID, resultWithValues);
                    }
                };
                for (Object referralUrl : referralUrls) {
                    try {
                        LdapUtils.followReferral(this.ldapConnection, (String)referralUrl, searchRequest, referralConsumer, this.depth + 1, searchResult, requestID);
                    }
                    catch (LDAPException e) {
                        LOGGER.warn(() -> LdapSearchResultListener.lambda$searchResultReceived$2((String)referralUrl), (Throwable)e);
                        referralConsumer.accept(requestID, new SearchResult(searchResult.getMessageID(), e.getResultCode(), e.getDiagnosticMessage(), e.getMatchedDN(), e.getReferralURLs(), 0, 0, e.getResponseControls()));
                    }
                }
            }
        }

        void setSearchRequest(SearchRequest searchRequest) {
            this.searchRequestRef.set((Object)searchRequest);
        }

        private static /* synthetic */ Object lambda$searchResultReceived$2(String referralUrl) {
            return new ParameterizedMessage("caught exception while trying to follow referral [{}]", (Object)referralUrl);
        }
    }

    private static class SingleEntryListener
    extends LdapSearchResultListener {
        SingleEntryListener(LDAPConnection ldapConnection, ActionListener<SearchResultEntry> listener, Filter filter) {
            super(ldapConnection, (AsyncRequestID asyncRequestID, SearchResult searchResult) -> {
                List entryList = searchResult.getSearchEntries();
                if (entryList.size() > 1) {
                    listener.onFailure((Exception)Exceptions.authenticationError("multiple search results found for [{}]", filter));
                } else if (entryList.size() == 1) {
                    listener.onResponse(entryList.get(0));
                } else {
                    listener.onResponse(null);
                }
            }, 1);
        }
    }
}

