/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc;

import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.xpack.security.authc.AuthenticationToken;
import org.elasticsearch.xpack.security.authc.RealmConfig;
import org.elasticsearch.xpack.security.user.User;

public abstract class Realm
implements Comparable<Realm> {
    protected final Logger logger;
    protected final String type;
    protected RealmConfig config;

    public Realm(String type, RealmConfig config) {
        this.type = type;
        this.config = config;
        this.logger = config.logger(this.getClass());
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.config.name;
    }

    public int order() {
        return this.config.order;
    }

    @Override
    public int compareTo(Realm other) {
        return Integer.compare(this.config.order, other.config.order);
    }

    public abstract boolean supports(AuthenticationToken var1);

    public abstract AuthenticationToken token(ThreadContext var1);

    @Deprecated
    public abstract User authenticate(AuthenticationToken var1);

    public void authenticate(AuthenticationToken token, ActionListener<User> listener) {
        try {
            listener.onResponse((Object)this.authenticate(token));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    @Deprecated
    public abstract User lookupUser(String var1);

    public void lookupUser(String username, ActionListener<User> listener) {
        try {
            User user = this.lookupUser(username);
            listener.onResponse((Object)user);
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public Map<String, Object> usageStats() {
        HashMap<String, Object> stats = new HashMap<String, Object>();
        stats.put("name", this.name());
        stats.put("order", this.order());
        return stats;
    }

    @Deprecated
    public abstract boolean userLookupSupported();

    public String toString() {
        return this.type + "/" + this.config.name;
    }

    public static interface Factory {
        public Realm create(RealmConfig var1) throws Exception;
    }
}

