/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.collector;

import java.util.Collection;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.monitoring.MonitoredSystem;
import org.elasticsearch.xpack.monitoring.MonitoringSettings;
import org.elasticsearch.xpack.monitoring.exporter.MonitoringDoc;

public abstract class Collector
extends AbstractComponent {
    private final String name;
    protected final ClusterService clusterService;
    protected final MonitoringSettings monitoringSettings;
    protected final XPackLicenseState licenseState;

    public Collector(Settings settings, String name, ClusterService clusterService, MonitoringSettings monitoringSettings, XPackLicenseState licenseState) {
        super(settings);
        this.name = name;
        this.clusterService = clusterService;
        this.monitoringSettings = monitoringSettings;
        this.licenseState = licenseState;
    }

    public String name() {
        return this.name;
    }

    public String toString() {
        return this.name();
    }

    protected boolean shouldCollect() {
        if (!this.licenseState.isMonitoringAllowed()) {
            this.logger.trace("collector [{}] can not collect data due to invalid license", (Object)this.name());
            return false;
        }
        return true;
    }

    protected boolean isLocalNodeMaster() {
        return this.clusterService.state().nodes().isLocalNodeElectedMaster();
    }

    public Collection<MonitoringDoc> collect() {
        try {
            if (this.shouldCollect()) {
                this.logger.trace("collector [{}] - collecting data...", (Object)this.name());
                return this.doCollect();
            }
        }
        catch (ElasticsearchTimeoutException e) {
            this.logger.error(() -> new ParameterizedMessage("collector [{}] timed out when collecting data", (Object)this.name()));
        }
        catch (Exception e) {
            this.logger.error(() -> new ParameterizedMessage("collector [{}] failed to collect data", (Object)this.name()), (Throwable)e);
        }
        return null;
    }

    protected abstract Collection<MonitoringDoc> doCollect() throws Exception;

    protected String clusterUUID() {
        return this.clusterService.state().metaData().clusterUUID();
    }

    protected DiscoveryNode localNode() {
        return this.clusterService.localNode();
    }

    protected static String monitoringId() {
        return MonitoredSystem.ES.getSystem();
    }

    protected static String monitoringVersion() {
        return Version.CURRENT.toString();
    }
}

