/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.client;

import java.util.Map;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.xpack.monitoring.action.MonitoringBulkAction;
import org.elasticsearch.xpack.monitoring.action.MonitoringBulkRequest;
import org.elasticsearch.xpack.monitoring.action.MonitoringBulkRequestBuilder;
import org.elasticsearch.xpack.monitoring.action.MonitoringBulkResponse;

public class MonitoringClient {
    private final Client client;

    @Inject
    public MonitoringClient(Client client) {
        this.client = client;
    }

    public MonitoringBulkRequestBuilder prepareMonitoringBulk() {
        return new MonitoringBulkRequestBuilder((ElasticsearchClient)this.client);
    }

    public void bulk(MonitoringBulkRequest request, ActionListener<MonitoringBulkResponse> listener) {
        this.client.execute((Action)MonitoringBulkAction.INSTANCE, (ActionRequest)request, listener);
    }

    public ActionFuture<MonitoringBulkResponse> bulk(MonitoringBulkRequest request) {
        return this.client.execute((Action)MonitoringBulkAction.INSTANCE, (ActionRequest)request);
    }

    public MonitoringClient filterWithHeader(Map<String, String> headers) {
        return new MonitoringClient(this.client.filterWithHeader(headers));
    }
}

