/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.graph;

import java.io.IOException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.XPackFeatureSet;
import org.elasticsearch.xpack.XPackSettings;

public class GraphFeatureSet
implements XPackFeatureSet {
    private final boolean enabled;
    private final XPackLicenseState licenseState;

    @Inject
    public GraphFeatureSet(Settings settings, @Nullable XPackLicenseState licenseState) {
        this.enabled = (Boolean)XPackSettings.GRAPH_ENABLED.get(settings);
        this.licenseState = licenseState;
    }

    @Override
    public String name() {
        return "graph";
    }

    @Override
    public String description() {
        return "Graph Data Exploration for the Elastic Stack";
    }

    @Override
    public boolean available() {
        return this.licenseState != null && this.licenseState.isGraphAllowed();
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public XPackFeatureSet.Usage usage() {
        return new Usage(this.available(), this.enabled());
    }

    public static class Usage
    extends XPackFeatureSet.Usage {
        public Usage(StreamInput input) throws IOException {
            super(input);
        }

        public Usage(boolean available, boolean enabled) {
            super("graph", available, enabled);
        }
    }
}

