/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.common.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.xpack.common.http.HttpProxy;
import org.elasticsearch.xpack.common.http.HttpRequest;
import org.elasticsearch.xpack.common.http.HttpResponse;
import org.elasticsearch.xpack.common.http.HttpSettings;
import org.elasticsearch.xpack.common.http.auth.ApplicableHttpAuth;
import org.elasticsearch.xpack.common.http.auth.HttpAuthRegistry;
import org.elasticsearch.xpack.ssl.SSLService;

public class HttpClient
extends AbstractComponent {
    private final HttpAuthRegistry httpAuthRegistry;
    private final TimeValue defaultConnectionTimeout;
    private final TimeValue defaultReadTimeout;
    private final boolean isHostnameVerificationEnabled;
    private final SSLSocketFactory sslSocketFactory;
    private final HttpProxy proxy;

    public HttpClient(Settings settings, HttpAuthRegistry httpAuthRegistry, SSLService sslService) {
        super(settings);
        this.httpAuthRegistry = httpAuthRegistry;
        this.defaultConnectionTimeout = (TimeValue)HttpSettings.CONNECTION_TIMEOUT.get(settings);
        this.defaultReadTimeout = (TimeValue)HttpSettings.READ_TIMEOUT.get(settings);
        Integer proxyPort = HttpSettings.PROXY_HOST.exists(settings) ? (Integer)HttpSettings.PROXY_PORT.get(settings) : null;
        String proxyHost = (String)HttpSettings.PROXY_HOST.get(settings);
        if (proxyPort != null && Strings.hasText((String)proxyHost)) {
            this.proxy = new HttpProxy(proxyHost, proxyPort);
            this.logger.info("Using default proxy for http input and slack/hipchat/pagerduty/webhook actions [{}:{}]", (Object)proxyHost, (Object)proxyPort);
        } else if (proxyPort == null && !Strings.hasText((String)proxyHost)) {
            this.proxy = HttpProxy.NO_PROXY;
        } else {
            throw new IllegalArgumentException("HTTP Proxy requires both settings: [xpack.http.proxy.host] and [xpack.http.proxy.port]");
        }
        Settings sslSettings = settings.getByPrefix("xpack.http.ssl.");
        this.sslSocketFactory = sslService.sslSocketFactory(settings.getByPrefix("xpack.http.ssl."));
        this.isHostnameVerificationEnabled = sslService.getVerificationMode(sslSettings, Settings.EMPTY).isHostnameVerificationEnabled();
    }

    public HttpResponse execute(HttpRequest request) throws IOException {
        try {
            return this.doExecute(request);
        }
        catch (SocketTimeoutException ste) {
            throw new ElasticsearchTimeoutException("failed to execute http request. timeout expired", (Throwable)ste, new Object[0]);
        }
    }

    public HttpResponse doExecute(HttpRequest request) throws IOException {
        byte[] body;
        String path;
        String queryString = null;
        if (request.params() != null && !request.params().isEmpty()) {
            StringBuilder builder = new StringBuilder();
            for (Map.Entry<String, String> entry : request.params().entrySet()) {
                if (builder.length() != 0) {
                    builder.append('&');
                }
                builder.append(URLEncoder.encode(entry.getKey(), "UTF-8")).append('=').append(URLEncoder.encode(entry.getValue(), "UTF-8"));
            }
            queryString = builder.toString();
        }
        String string = path = Strings.hasLength((String)request.path) ? request.path : "";
        if (Strings.hasLength(queryString)) {
            path = path + "?" + queryString;
        }
        URL url = new URL(request.scheme.scheme(), request.host, request.port, path);
        this.logger.debug("making [{}] request to [{}]", (Object)request.method().method(), (Object)url);
        this.logger.trace("sending [{}] as body of request", (Object)request.body());
        HttpProxy proxyToUse = request.proxy != null ? request.proxy : this.proxy;
        HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection(proxyToUse.proxy());
        if (urlConnection instanceof HttpsURLConnection) {
            final HttpsURLConnection httpsConn = (HttpsURLConnection)urlConnection;
            final SSLSocketFactory sSLSocketFactory = this.sslSocketFactory;
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission((Permission)new SpecialPermission());
            }
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    httpsConn.setSSLSocketFactory(sSLSocketFactory);
                    if (!HttpClient.this.isHostnameVerificationEnabled) {
                        httpsConn.setHostnameVerifier(NoopHostnameVerifier.INSTANCE);
                    }
                    return null;
                }
            });
        }
        urlConnection.setRequestMethod(request.method().method());
        if (request.headers() != null) {
            for (Map.Entry entry : request.headers().entrySet()) {
                urlConnection.setRequestProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (request.auth() != null) {
            this.logger.trace("applying auth headers");
            Object applicableAuth = this.httpAuthRegistry.createApplicable(request.auth);
            ((ApplicableHttpAuth)applicableAuth).apply(urlConnection);
        }
        urlConnection.setUseCaches(false);
        urlConnection.setRequestProperty("Accept-Charset", StandardCharsets.UTF_8.name());
        if (request.body() != null) {
            urlConnection.setDoOutput(true);
            byte[] bytes = request.body().getBytes(StandardCharsets.UTF_8.name());
            urlConnection.setRequestProperty("Content-Length", String.valueOf(bytes.length));
            urlConnection.getOutputStream().write(bytes);
            urlConnection.getOutputStream().close();
        }
        TimeValue connectionTimeout = request.connectionTimeout != null ? request.connectionTimeout : this.defaultConnectionTimeout;
        urlConnection.setConnectTimeout((int)connectionTimeout.millis());
        TimeValue timeValue = request.readTimeout != null ? request.readTimeout : this.defaultReadTimeout;
        urlConnection.setReadTimeout((int)timeValue.millis());
        urlConnection.connect();
        int statusCode = urlConnection.getResponseCode();
        if (statusCode == -1) {
            throw new IOException("Not a valid HTTP response, no status code in response");
        }
        HashMap<String, String[]> responseHeaders = new HashMap<String, String[]>(urlConnection.getHeaderFields().size());
        for (Map.Entry<String, List<String>> header : urlConnection.getHeaderFields().entrySet()) {
            if (header.getKey() == null) continue;
            responseHeaders.put(header.getKey(), header.getValue().toArray(new String[header.getValue().size()]));
        }
        this.logger.debug("http status code [{}]", (Object)statusCode);
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            block50: {
                try (InputStream is = urlConnection.getInputStream();){
                    Streams.copy((InputStream)is, (OutputStream)outputStream);
                }
                catch (Exception e) {
                    if (urlConnection.getErrorStream() == null) break block50;
                    try (InputStream is2 = urlConnection.getErrorStream();){
                        Streams.copy((InputStream)is2, (OutputStream)outputStream);
                    }
                }
            }
            body = outputStream.toByteArray();
        }
        return new HttpResponse(statusCode, body, responseHeaders);
    }

    private static final class NoopHostnameVerifier
    implements HostnameVerifier {
        private static final HostnameVerifier INSTANCE = new NoopHostnameVerifier();

        private NoopHostnameVerifier() {
        }

        @Override
        public boolean verify(String s, SSLSession sslSession) {
            return true;
        }
    }
}

