/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.common;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.common.util.concurrent.CountDown;

public final class GroupedActionListener<T>
implements ActionListener<T> {
    private final CountDown countDown;
    private final AtomicInteger pos = new AtomicInteger();
    private final AtomicArray<T> roles;
    private final ActionListener<Collection<T>> delegate;
    private final Collection<T> defaults;
    private final AtomicReference<Exception> failure = new AtomicReference();

    public GroupedActionListener(ActionListener<Collection<T>> delegate, int groupSize, Collection<T> defaults) {
        this.roles = new AtomicArray(groupSize);
        this.countDown = new CountDown(groupSize);
        this.delegate = delegate;
        this.defaults = defaults;
    }

    public void onResponse(T element) {
        this.roles.set(this.pos.incrementAndGet() - 1, element);
        if (this.countDown.countDown()) {
            if (this.failure.get() != null) {
                this.delegate.onFailure(this.failure.get());
            } else {
                List collect = this.roles.asList().stream().map(e -> e.value).filter(Objects::nonNull).collect(Collectors.toList());
                collect.addAll(this.defaults);
                this.delegate.onResponse(Collections.unmodifiableList(collect));
            }
        }
    }

    public void onFailure(Exception e) {
        if (!this.failure.compareAndSet(null, e)) {
            this.failure.get().addSuppressed(e);
        }
        if (this.countDown.countDown()) {
            this.delegate.onFailure(this.failure.get());
        }
    }
}

