/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle.vagrant;

import java.io.File;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.UnaryOperator;
import javax.inject.Inject;
import org.apache.commons.io.output.TeeOutputStream;
import org.elasticsearch.gradle.LoggedExec;
import org.elasticsearch.gradle.LoggingOutputStream;
import org.elasticsearch.gradle.ReaperService;
import org.elasticsearch.gradle.util.Util;
import org.elasticsearch.gradle.vagrant.VagrantExtension;
import org.elasticsearch.gradle.vagrant.VagrantProgressLogger;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.internal.logging.progress.ProgressLogger;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.gradle.process.ExecSpec;

public class VagrantMachine {
    private final Project project;
    private final VagrantExtension extension;
    private final ReaperService reaper;
    long refs;
    private boolean isVMStarted = false;

    public VagrantMachine(Project project, VagrantExtension extension, ReaperService reaper) {
        this.project = project;
        this.extension = extension;
        this.reaper = reaper;
    }

    @Inject
    protected ProgressLoggerFactory getProgressLoggerFactory() {
        throw new UnsupportedOperationException();
    }

    public void execute(Action<VagrantExecSpec> action) {
        VagrantExecSpec vagrantSpec = new VagrantExecSpec();
        action.execute((Object)vagrantSpec);
        Objects.requireNonNull(vagrantSpec.command);
        LoggedExec.exec(this.project, (Action<ExecSpec>)((Action)execSpec -> {
            UnaryOperator progressHandler;
            execSpec.setExecutable("vagrant");
            File vagrantfile = this.extension.getVagrantfile();
            execSpec.setEnvironment(System.getenv());
            execSpec.environment("VAGRANT_CWD", (Object)vagrantfile.getParentFile().toString());
            execSpec.environment("VAGRANT_VAGRANTFILE", (Object)vagrantfile.getName());
            execSpec.environment("VAGRANT_LOG", (Object)"debug");
            this.extension.getHostEnv().forEach((arg_0, arg_1) -> ((ExecSpec)execSpec).environment(arg_0, arg_1));
            execSpec.args(new Object[]{vagrantSpec.command});
            if (vagrantSpec.subcommand != null) {
                execSpec.args(new Object[]{vagrantSpec.subcommand});
            }
            execSpec.args(new Object[]{this.extension.getBox()});
            if (vagrantSpec.args != null) {
                execSpec.args(Arrays.asList(vagrantSpec.args));
            }
            if ((progressHandler = vagrantSpec.progressHandler) == null) {
                progressHandler = new VagrantProgressLogger("==> " + this.extension.getBox() + ": ");
            }
            OutputStream output = execSpec.getStandardOutput();
            ProgressOutputStream progressStream = new ProgressOutputStream(vagrantSpec.command, progressHandler);
            execSpec.setStandardOutput((OutputStream)new TeeOutputStream(output, (OutputStream)progressStream));
        }));
    }

    void maybeStartVM() {
        if (this.isVMStarted) {
            return;
        }
        this.execute((Action<VagrantExecSpec>)((Action)spec -> {
            spec.setCommand("box");
            spec.setSubcommand("update");
        }));
        boolean destroyVM = Util.getBooleanProperty("vagrant.destroy", true);
        if (destroyVM) {
            this.execute((Action<VagrantExecSpec>)((Action)spec -> {
                spec.setCommand("destroy");
                spec.setArgs("--force");
            }));
        }
        this.reaper.registerCommand(this.extension.getBox(), "vagrant", "halt", "-f", this.extension.getBox());
        this.execute((Action<VagrantExecSpec>)((Action)spec -> {
            spec.setCommand("up");
            spec.setArgs("--provision", "--provider", "virtualbox");
        }));
        this.isVMStarted = true;
    }

    void maybeStopVM(boolean force) {
        assert (this.refs >= 1L);
        --this.refs;
        if ((this.refs == 0L || force) && this.isVMStarted) {
            this.execute((Action<VagrantExecSpec>)((Action)spec -> spec.setCommand("halt")));
            this.reaper.unregister(this.extension.getBox());
        }
    }

    public static String convertLinuxPath(Project project, String path) {
        return "/elasticsearch/" + project.getRootDir().toPath().relativize(Paths.get(path, new String[0]));
    }

    public static String convertWindowsPath(Project project, String path) {
        return "C:\\elasticsearch\\" + project.getRootDir().toPath().relativize(Paths.get(path, new String[0])).toString().replace('/', '\\');
    }

    public static class VagrantExecSpec {
        private String command;
        private String subcommand;
        private String[] args;
        private UnaryOperator<String> progressHandler;

        private VagrantExecSpec() {
        }

        public void setCommand(String command) {
            this.command = command;
        }

        public void setSubcommand(String subcommand) {
            this.subcommand = subcommand;
        }

        public void setArgs(String ... args) {
            this.args = args;
        }

        public void setProgressHandler(UnaryOperator<String> progressHandler) {
            this.progressHandler = progressHandler;
        }
    }

    private class ProgressOutputStream
    extends LoggingOutputStream {
        private ProgressLogger progressLogger;
        private UnaryOperator<String> progressHandler;

        ProgressOutputStream(String command, UnaryOperator<String> progressHandler) {
            this.progressHandler = progressHandler;
            this.progressLogger = VagrantMachine.this.getProgressLoggerFactory().newOperation("vagrant");
            this.progressLogger.start(VagrantMachine.this.extension.getBox() + "> " + command, "hello");
        }

        @Override
        protected void logLine(String line) {
            String progress = (String)this.progressHandler.apply(line);
            if (progress != null) {
                this.progressLogger.progress(progress);
            }
        }

        @Override
        public void close() {
            this.progressLogger.completed();
        }
    }
}

