/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle.vagrant;

import java.util.Formatter;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.logging.Logger;

public class BatsProgressLogger
implements UnaryOperator<String> {
    private static final Pattern lineRegex = Pattern.compile("(?<status>ok|not ok) \\d+(?<skip> # skip (?<skipReason>\\(.+\\))?)? \\[(?<suite>.+)\\] (?<test>.+)");
    private static final Pattern startRegex = Pattern.compile("1..(\\d+)");
    private final Logger logger;
    private int testsCompleted = 0;
    private int testsFailed = 0;
    private int testsSkipped = 0;
    private Integer testCount;
    private String countsFormat;

    public BatsProgressLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public String apply(String line) {
        String status;
        if (this.testCount == null) {
            Matcher m = startRegex.matcher(line);
            if (!m.matches()) {
                return line;
            }
            this.testCount = Integer.parseInt(m.group(1));
            int length = String.valueOf(this.testCount).length();
            String count = "%0" + length + "d";
            this.countsFormat = "[" + count + "|" + count + "|" + count + "/" + count + "]";
            return null;
        }
        Matcher m = lineRegex.matcher(line);
        if (!m.matches()) {
            this.logger.warn(line);
            return null;
        }
        boolean skipped = m.group("skip") != null;
        boolean success = !skipped && m.group("status").equals("ok");
        String skipReason = m.group("skipReason");
        String suiteName = m.group("suite");
        String testName = m.group("test");
        if (skipped) {
            status = "SKIPPED";
            ++this.testsSkipped;
        } else if (success) {
            status = "     OK";
            ++this.testsCompleted;
        } else {
            status = " FAILED";
            ++this.testsFailed;
        }
        String counts = new Formatter().format(this.countsFormat, this.testsCompleted, this.testsFailed, this.testsSkipped, this.testCount).out().toString();
        if (!success) {
            this.logger.warn(line);
        }
        return "BATS " + counts + ", " + status + " [" + suiteName + "] " + testName;
    }
}

