/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle.testclusters;

import java.io.File;
import org.elasticsearch.gradle.Architecture;
import org.elasticsearch.gradle.DistributionDownloadPlugin;
import org.elasticsearch.gradle.Jdk;
import org.elasticsearch.gradle.JdkDownloadPlugin;
import org.elasticsearch.gradle.OS;
import org.elasticsearch.gradle.ReaperPlugin;
import org.elasticsearch.gradle.ReaperService;
import org.elasticsearch.gradle.testclusters.ElasticsearchCluster;
import org.elasticsearch.gradle.testclusters.TestClustersAware;
import org.elasticsearch.gradle.testclusters.TestClustersRegistry;
import org.elasticsearch.gradle.testclusters.TestClustersThrottle;
import org.elasticsearch.gradle.util.GradleUtils;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskActionListener;
import org.gradle.api.execution.TaskExecutionListener;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskState;

public class TestClustersPlugin
implements Plugin<Project> {
    public static final String EXTENSION_NAME = "testClusters";
    public static final String THROTTLE_SERVICE_NAME = "testClustersThrottle";
    private static final String LIST_TASK_NAME = "listTestClusters";
    private static final String REGISTRY_SERVICE_NAME = "testClustersRegistry";
    private static final String LEGACY_JAVA_VENDOR = "adoptopenjdk";
    private static final String LEGACY_JAVA_VERSION = "8u242+b08";
    private static final Logger logger = Logging.getLogger(TestClustersPlugin.class);

    public void apply(Project project) {
        project.getPluginManager().apply(DistributionDownloadPlugin.class);
        project.getPluginManager().apply(JdkDownloadPlugin.class);
        project.getRootProject().getPluginManager().apply(ReaperPlugin.class);
        ReaperService reaper = (ReaperService)project.getRootProject().getExtensions().getByType(ReaperService.class);
        Jdk bwcJdk = (Jdk)JdkDownloadPlugin.getContainer(project).create("bwc_jdk", jdk -> {
            jdk.setVendor(LEGACY_JAVA_VENDOR);
            jdk.setVersion(LEGACY_JAVA_VERSION);
            jdk.setPlatform(OS.current().name().toLowerCase());
            jdk.setArchitecture(Architecture.current().name().toLowerCase());
        });
        NamedDomainObjectContainer<ElasticsearchCluster> container = this.createTestClustersContainerExtension(project, reaper, bwcJdk);
        this.createListClustersTask(project, container);
        project.getGradle().getSharedServices().registerIfAbsent(REGISTRY_SERVICE_NAME, TestClustersRegistry.class, GradleUtils.noop());
        project.getGradle().getSharedServices().registerIfAbsent(THROTTLE_SERVICE_NAME, TestClustersThrottle.class, spec -> spec.getMaxParallelUsages().set((Object)Math.max(1, project.getGradle().getStartParameter().getMaxWorkerCount() / 2)));
        project.getRootProject().getPluginManager().apply(TestClustersHookPlugin.class);
    }

    private NamedDomainObjectContainer<ElasticsearchCluster> createTestClustersContainerExtension(Project project, ReaperService reaper, Jdk bwcJdk) {
        NamedDomainObjectContainer container = project.container(ElasticsearchCluster.class, name -> new ElasticsearchCluster(name, project, reaper, new File(project.getBuildDir(), "testclusters"), bwcJdk));
        project.getExtensions().add(EXTENSION_NAME, (Object)container);
        return container;
    }

    private void createListClustersTask(Project project, NamedDomainObjectContainer<ElasticsearchCluster> container) {
        Task listTask = project.getTasks().create(LIST_TASK_NAME);
        listTask.setGroup("ES cluster formation");
        listTask.setDescription("Lists all ES clusters configured for this project");
        listTask.doLast(task -> container.forEach(cluster -> logger.lifecycle("   * {}: {}", new Object[]{cluster.getName(), cluster.getNumberOfNodes()})));
    }

    static class TestClustersHookPlugin
    implements Plugin<Project> {
        TestClustersHookPlugin() {
        }

        public void apply(Project project) {
            if (project != project.getRootProject()) {
                throw new IllegalStateException(this.getClass().getName() + " can only be applied to the root project.");
            }
            Provider registryProvider = GradleUtils.getBuildService(project.getGradle().getSharedServices(), TestClustersPlugin.REGISTRY_SERVICE_NAME);
            TestClustersRegistry registry = (TestClustersRegistry)registryProvider.get();
            TestClustersHookPlugin.configureClaimClustersHook(project.getGradle(), registry);
            TestClustersHookPlugin.configureStartClustersHook(project.getGradle(), registry);
            TestClustersHookPlugin.configureStopClustersHook(project.getGradle(), registry);
        }

        private static void configureClaimClustersHook(Gradle gradle, TestClustersRegistry registry) {
            gradle.getTaskGraph().whenReady(taskExecutionGraph -> taskExecutionGraph.getAllTasks().stream().filter(task -> task instanceof TestClustersAware).map(task -> (TestClustersAware)task).flatMap(task -> task.getClusters().stream()).forEach(registry::claimCluster));
        }

        private static void configureStartClustersHook(Gradle gradle, final TestClustersRegistry registry) {
            gradle.addListener((Object)new TaskActionListener(){

                public void beforeActions(Task task) {
                    if (!(task instanceof TestClustersAware)) {
                        return;
                    }
                    TestClustersAware awareTask = (TestClustersAware)task;
                    awareTask.beforeStart();
                    awareTask.getClusters().forEach(registry::maybeStartCluster);
                }

                public void afterActions(Task task) {
                }
            });
        }

        private static void configureStopClustersHook(Gradle gradle, final TestClustersRegistry registry) {
            gradle.addListener((Object)new TaskExecutionListener(){

                public void afterExecute(Task task, TaskState state) {
                    if (!(task instanceof TestClustersAware)) {
                        return;
                    }
                    ((TestClustersAware)task).getClusters().forEach(cluster -> registry.stopCluster((ElasticsearchCluster)cluster, state.getFailure() != null));
                }

                public void beforeExecute(Task task) {
                }
            });
        }
    }
}

