/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle.tar;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Set;
import java.util.function.Function;
import javax.inject.Inject;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;

public class SymbolicLinkPreservingUntarTask
extends DefaultTask {
    private final RegularFileProperty tarFile;
    private final DirectoryProperty extractPath;
    private Function<String, Path> transform;

    @InputFile
    public RegularFileProperty getTarFile() {
        return this.tarFile;
    }

    @OutputDirectory
    public DirectoryProperty getExtractPath() {
        return this.extractPath;
    }

    @Internal
    public Function<String, Path> getTransform() {
        return this.transform;
    }

    public void setTransform(Function<String, Path> transform) {
        this.transform = transform;
    }

    @Inject
    public SymbolicLinkPreservingUntarTask(ObjectFactory objectFactory) {
        this.tarFile = objectFactory.fileProperty();
        this.extractPath = objectFactory.directoryProperty();
        this.transform = name -> Paths.get(name, new String[0]);
    }

    @TaskAction
    final void execute() {
        this.getProject().delete(new Object[]{this.extractPath});
        try (TarArchiveInputStream tar = new TarArchiveInputStream((InputStream)new GzipCompressorInputStream((InputStream)new FileInputStream((File)this.tarFile.getAsFile().get())));){
            Path destinationPath = ((Directory)this.extractPath.get()).getAsFile().toPath();
            TarArchiveEntry entry = tar.getNextTarEntry();
            while (entry != null) {
                PosixFileAttributeView view;
                Path relativePath = this.transform.apply(entry.getName());
                if (relativePath == null) {
                    entry = tar.getNextTarEntry();
                    continue;
                }
                Path destination = destinationPath.resolve(relativePath);
                Path parent = destination.getParent();
                if (!Files.exists(parent, new LinkOption[0])) {
                    Files.createDirectories(parent, new FileAttribute[0]);
                }
                if (entry.isDirectory()) {
                    Files.createDirectory(destination, new FileAttribute[0]);
                } else if (entry.isSymbolicLink()) {
                    Files.createSymbolicLink(destination, Paths.get(entry.getLinkName(), new String[0]), new FileAttribute[0]);
                } else {
                    Files.createFile(destination, new FileAttribute[0]);
                    try (FileOutputStream fos = new FileOutputStream(destination.toFile());){
                        tar.transferTo((OutputStream)fos);
                    }
                }
                if (!entry.isSymbolicLink() && (view = Files.getFileAttributeView(destination, PosixFileAttributeView.class, new LinkOption[0])) != null) {
                    Set<PosixFilePermission> permissions = PosixFilePermissions.fromString(this.permissions(entry.getMode() >> 6 & 7) + this.permissions(entry.getMode() >> 3 & 7) + this.permissions(entry.getMode() >> 0 & 7));
                    Files.setPosixFilePermissions(destination, permissions);
                }
                entry = tar.getNextTarEntry();
            }
        }
        catch (IOException e) {
            throw new GradleException("unable to extract tar [" + ((File)this.tarFile.getAsFile().get()).toPath() + "]", (Throwable)e);
        }
    }

    private String permissions(int permissions) {
        if (permissions < 0 || permissions > 7) {
            throw new IllegalArgumentException("permissions [" + permissions + "] out of range");
        }
        StringBuilder sb = new StringBuilder(3);
        if ((permissions & 4) == 4) {
            sb.append('r');
        } else {
            sb.append('-');
        }
        if ((permissions & 2) == 2) {
            sb.append('w');
        } else {
            sb.append('-');
        }
        if ((permissions & 1) == 1) {
            sb.append('x');
        } else {
            sb.append('-');
        }
        return sb.toString();
    }
}

