/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle.precommit;

import java.io.File;
import org.elasticsearch.gradle.precommit.ValidateJsonAgainstSchemaTask;
import org.elasticsearch.gradle.util.Util;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.util.PatternFilterable;

public class ValidateRestSpecPlugin
implements Plugin<Project> {
    private static final String DOUBLE_STAR = "**";

    public void apply(Project project) {
        TaskProvider validateRestSpecTask = project.getTasks().register("validateRestSpec", ValidateJsonAgainstSchemaTask.class, task -> {
            task.setInputFiles((FileCollection)Util.getJavaTestAndMainSourceResources(project, (Action<? super PatternFilterable>)((Action)filter -> {
                filter.include(new String[]{"**/rest-api-spec/api/**/*.json"});
                filter.exclude(new String[]{"**/_common.json"});
            })));
            task.setJsonSchema(new File(project.getRootDir(), "rest-api-spec/src/main/resources/schema.json"));
        });
        project.getTasks().named("precommit").configure(arg_0 -> ValidateRestSpecPlugin.lambda$apply$2((Provider)validateRestSpecTask, arg_0));
    }

    private static /* synthetic */ void lambda$apply$2(Provider validateRestSpecTask, Task t) {
        t.dependsOn(new Object[]{validateRestSpecTask});
    }
}

