/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle.precommit;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaException;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SchemaValidatorsConfig;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.ValidationMessage;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.StreamSupport;
import org.gradle.api.DefaultTask;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.ChangeType;
import org.gradle.work.Incremental;
import org.gradle.work.InputChanges;

public class ValidateJsonAgainstSchemaTask
extends DefaultTask {
    private final ObjectMapper mapper = new ObjectMapper();
    private Set<String> ignore = new HashSet<String>();
    private File jsonSchema;
    private FileCollection inputFiles;

    @Incremental
    @InputFiles
    public FileCollection getInputFiles() {
        return this.inputFiles;
    }

    public void setInputFiles(FileCollection inputFiles) {
        this.inputFiles = inputFiles;
    }

    @InputFile
    public File getJsonSchema() {
        return this.jsonSchema;
    }

    public void setJsonSchema(File jsonSchema) {
        this.jsonSchema = jsonSchema;
    }

    @Input
    @Optional
    public Set<String> getIgnore() {
        return this.ignore;
    }

    public void ignore(String ... ignore) {
        this.ignore.addAll(Arrays.asList(ignore));
    }

    @OutputFile
    public File getReport() {
        return new File(this.getProject().getBuildDir(), "reports/validateJson.txt");
    }

    @TaskAction
    public void validate(InputChanges inputChanges) throws IOException {
        File jsonSchemaOnDisk = this.getJsonSchema();
        this.getLogger().debug("JSON schema : [{}]", (Object)jsonSchemaOnDisk.getAbsolutePath());
        SchemaValidatorsConfig config = new SchemaValidatorsConfig();
        JsonSchemaFactory factory = JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)SpecVersion.VersionFlag.V7);
        JsonSchema jsonSchema = factory.getSchema(this.mapper.readTree(jsonSchemaOnDisk), config);
        LinkedHashMap errors = new LinkedHashMap();
        StreamSupport.stream(inputChanges.getFileChanges(this.getInputFiles()).spliterator(), false).filter(f -> f.getChangeType() != ChangeType.REMOVED).forEach(fileChange -> {
            File file = fileChange.getFile();
            if (this.ignore.contains(file.getName())) {
                this.getLogger().debug("Ignoring file [{}] due to configuration", (Object)file.getName());
            } else if (!file.isDirectory()) {
                this.getLogger().debug("Validating JSON [{}]", (Object)file.getName());
                try {
                    Set validationMessages = jsonSchema.validate(this.mapper.readTree(file));
                    this.maybeLogAndCollectError(validationMessages, errors, file);
                }
                catch (IOException e) {
                    throw new UncheckedIOException((Throwable)e);
                }
            }
        });
        if (errors.isEmpty()) {
            try (PrintWriter printWriter = new PrintWriter(this.getReport());){
                printWriter.println("Success! No validation errors found.");
            }
        }
        try (PrintWriter printWriter = new PrintWriter(this.getReport());){
            printWriter.printf("Schema: %s%n", jsonSchemaOnDisk);
            printWriter.println("----------Validation Errors-----------");
            errors.values().stream().flatMap(Collection::stream).forEach(printWriter::println);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Error validating JSON. See the report at: ");
        sb.append(this.getReport().toURI().toASCIIString());
        sb.append(System.lineSeparator());
        sb.append(String.format("JSON validation failed: %d files contained %d violations", errors.keySet().size(), errors.values().size()));
        throw new JsonSchemaException(sb.toString());
    }

    private void maybeLogAndCollectError(Set<ValidationMessage> messages, Map<File, Set<String>> errors, File file) {
        for (ValidationMessage message : messages) {
            this.getLogger().error("[validate JSON][ERROR][{}][{}]", (Object)file.getName(), (Object)message.toString());
            errors.computeIfAbsent(file, k -> new LinkedHashSet()).add(String.format("%s: %s", file.getAbsolutePath(), message.toString()));
        }
    }
}

