/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle.precommit;

import org.elasticsearch.gradle.precommit.PomValidationTask;
import org.elasticsearch.gradle.util.Util;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.maven.plugins.MavenPublishPlugin;
import org.gradle.api.publish.maven.tasks.GenerateMavenPom;
import org.gradle.api.tasks.TaskProvider;

public class PomValidationPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getPlugins().withType(MavenPublishPlugin.class).whenPluginAdded(p -> {
            PublishingExtension publishing = (PublishingExtension)project.getExtensions().getByType(PublishingExtension.class);
            publishing.getPublications().all(publication -> {
                String publicationName = Util.capitalize(publication.getName());
                TaskProvider validateTask = project.getTasks().register("validate" + publicationName + "Pom", PomValidationTask.class);
                validateTask.configure(task -> {
                    GenerateMavenPom generateMavenPom = (GenerateMavenPom)project.getTasks().withType(GenerateMavenPom.class).getByName("generatePomFileFor" + publicationName + "Publication");
                    task.dependsOn(new Object[]{generateMavenPom});
                    task.getPomFile().fileValue(generateMavenPom.getDestination());
                });
                project.getTasks().named("precommit").configure(precommit -> precommit.dependsOn(new Object[]{validateTask}));
            });
        });
    }
}

