/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle.info;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.elasticsearch.gradle.OS;
import org.elasticsearch.gradle.info.BuildParams;
import org.elasticsearch.gradle.info.JavaHome;
import org.elasticsearch.gradle.util.Util;
import org.gradle.api.GradleException;
import org.gradle.api.JavaVersion;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.internal.jvm.Jvm;
import org.gradle.jvm.toolchain.JavaInstallation;
import org.gradle.jvm.toolchain.JavaInstallationRegistry;
import org.gradle.util.GradleVersion;

public class GlobalBuildInfoPlugin
implements Plugin<Project> {
    private static final Logger LOGGER = Logging.getLogger(GlobalBuildInfoPlugin.class);
    private static Integer _defaultParallel = null;
    private final JavaInstallationRegistry javaInstallationRegistry;
    private final ObjectFactory objects;
    private final ProviderFactory providers;

    @Inject
    public GlobalBuildInfoPlugin(JavaInstallationRegistry javaInstallationRegistry, ObjectFactory objects, ProviderFactory providers) {
        this.javaInstallationRegistry = javaInstallationRegistry;
        this.objects = objects;
        this.providers = providers;
    }

    public void apply(Project project) {
        if (project != project.getRootProject()) {
            throw new IllegalStateException(this.getClass().getName() + " can only be applied to the root project.");
        }
        JavaVersion minimumCompilerVersion = JavaVersion.toVersion((Object)Util.getResourceContents("/minimumCompilerVersion"));
        JavaVersion minimumRuntimeVersion = JavaVersion.toVersion((Object)Util.getResourceContents("/minimumRuntimeVersion"));
        File compilerJavaHome = GlobalBuildInfoPlugin.findCompilerJavaHome();
        File runtimeJavaHome = GlobalBuildInfoPlugin.findRuntimeJavaHome(compilerJavaHome);
        GitInfo gitInfo = GlobalBuildInfoPlugin.gitInfo(project.getRootProject().getRootDir());
        BuildParams.init(params -> {
            params.reset();
            params.setCompilerJavaHome(compilerJavaHome);
            params.setRuntimeJavaHome(runtimeJavaHome);
            params.setCompilerJavaVersion(this.determineJavaVersion("compiler java.home", compilerJavaHome, minimumCompilerVersion));
            params.setRuntimeJavaVersion(this.determineJavaVersion("runtime java.home", runtimeJavaHome, minimumRuntimeVersion));
            params.setIsRutimeJavaHomeSet(!compilerJavaHome.equals(runtimeJavaHome));
            params.setJavaVersions(this.getAvailableJavaVersions(minimumCompilerVersion));
            params.setMinimumCompilerVersion(minimumCompilerVersion);
            params.setMinimumRuntimeVersion(minimumRuntimeVersion);
            params.setGradleJavaVersion(Jvm.current().getJavaVersion());
            params.setGitRevision(gitInfo.getRevision());
            params.setGitOrigin(gitInfo.getOrigin());
            params.setBuildDate(ZonedDateTime.now(ZoneOffset.UTC));
            params.setTestSeed(GlobalBuildInfoPlugin.getTestSeed());
            params.setIsCi(System.getenv("JENKINS_URL") != null);
            params.setIsInternal(GlobalBuildInfoPlugin.class.getResource("/buildSrc.marker") != null);
            params.setDefaultParallel(GlobalBuildInfoPlugin.findDefaultParallel(project));
            params.setInFipsJvm(Util.getBooleanProperty("tests.fips.enabled", false));
            params.setIsSnapshotBuild(Util.getBooleanProperty("build.snapshot", true));
        });
        project.getGradle().getTaskGraph().whenReady(graph -> this.logGlobalBuildInfo());
    }

    private void logGlobalBuildInfo() {
        String osName = System.getProperty("os.name");
        String osVersion = System.getProperty("os.version");
        String osArch = System.getProperty("os.arch");
        Jvm gradleJvm = Jvm.current();
        String gradleJvmDetails = this.getJavaInstallation(gradleJvm.getJavaHome()).getImplementationName();
        LOGGER.quiet("=======================================");
        LOGGER.quiet("Elasticsearch Build Hamster says Hello!");
        LOGGER.quiet("  Gradle Version        : " + GradleVersion.current().getVersion());
        LOGGER.quiet("  OS Info               : " + osName + " " + osVersion + " (" + osArch + ")");
        if (!Jvm.current().getJavaVersion().equals((Object)BuildParams.getCompilerJavaVersion()) || BuildParams.getIsRuntimeJavaHomeSet().booleanValue()) {
            String compilerJvmDetails = this.getJavaInstallation(BuildParams.getCompilerJavaHome()).getImplementationName();
            String runtimeJvmDetails = this.getJavaInstallation(BuildParams.getRuntimeJavaHome()).getImplementationName();
            LOGGER.quiet("  Compiler JDK Version  : " + BuildParams.getCompilerJavaVersion() + " (" + compilerJvmDetails + ")");
            LOGGER.quiet("  Compiler java.home    : " + BuildParams.getCompilerJavaHome());
            LOGGER.quiet("  Runtime JDK Version   : " + BuildParams.getRuntimeJavaVersion() + " (" + runtimeJvmDetails + ")");
            LOGGER.quiet("  Runtime java.home     : " + BuildParams.getRuntimeJavaHome());
            LOGGER.quiet("  Gradle JDK Version    : " + gradleJvm.getJavaVersion() + " (" + gradleJvmDetails + ")");
            LOGGER.quiet("  Gradle java.home      : " + gradleJvm.getJavaHome());
        } else {
            LOGGER.quiet("  JDK Version           : " + gradleJvm.getJavaVersion() + " (" + gradleJvmDetails + ")");
            LOGGER.quiet("  JAVA_HOME             : " + gradleJvm.getJavaHome());
        }
        LOGGER.quiet("  Random Testing Seed   : " + BuildParams.getTestSeed());
        LOGGER.quiet("  In FIPS 140 mode      : " + BuildParams.isInFipsJvm());
        LOGGER.quiet("=======================================");
    }

    private JavaVersion determineJavaVersion(String description, File javaHome, JavaVersion requiredVersion) {
        JavaInstallation installation = this.getJavaInstallation(javaHome);
        JavaVersion actualVersion = installation.getJavaVersion();
        if (!actualVersion.isCompatibleWith(requiredVersion)) {
            GlobalBuildInfoPlugin.throwInvalidJavaHomeException(description, javaHome, Integer.parseInt(requiredVersion.getMajorVersion()), Integer.parseInt(actualVersion.getMajorVersion()));
        }
        return actualVersion;
    }

    private JavaInstallation getJavaInstallation(File javaHome) {
        JavaInstallation installation = GlobalBuildInfoPlugin.isCurrentJavaHome(javaHome) ? (JavaInstallation)this.javaInstallationRegistry.getInstallationForCurrentVirtualMachine().get() : (JavaInstallation)this.javaInstallationRegistry.installationForDirectory((Provider)this.objects.directoryProperty().fileValue(javaHome)).get();
        return installation;
    }

    private List<JavaHome> getAvailableJavaVersions(JavaVersion minimumCompilerVersion) {
        ArrayList<JavaHome> javaVersions = new ArrayList<JavaHome>();
        for (int v = 8; v <= Integer.parseInt(minimumCompilerVersion.getMajorVersion()); ++v) {
            int version = v;
            String javaHomeEnvVarName = GlobalBuildInfoPlugin.getJavaHomeEnvVarName(Integer.toString(version));
            if (System.getenv(javaHomeEnvVarName) == null) continue;
            File javaHomeDirectory = new File(GlobalBuildInfoPlugin.findJavaHome(Integer.toString(version)));
            Provider javaInstallationProvider = this.javaInstallationRegistry.installationForDirectory((Provider)this.objects.directoryProperty().fileValue(javaHomeDirectory));
            JavaHome javaHome = JavaHome.of(version, (Provider<File>)this.providers.provider(() -> {
                int actualVersion = Integer.parseInt(((JavaInstallation)javaInstallationProvider.get()).getJavaVersion().getMajorVersion());
                if (actualVersion != version) {
                    GlobalBuildInfoPlugin.throwInvalidJavaHomeException("env variable " + javaHomeEnvVarName, javaHomeDirectory, version, actualVersion);
                }
                return javaHomeDirectory;
            }));
            javaVersions.add(javaHome);
        }
        return javaVersions;
    }

    private static boolean isCurrentJavaHome(File javaHome) {
        try {
            return Files.isSameFile(javaHome.toPath(), Jvm.current().getJavaHome().toPath());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static String getTestSeed() {
        String testSeed;
        String testSeedProperty = System.getProperty("tests.seed");
        if (testSeedProperty == null) {
            long seed = new Random(System.currentTimeMillis()).nextLong();
            testSeed = Long.toUnsignedString(seed, 16).toUpperCase(Locale.ROOT);
        } else {
            testSeed = testSeedProperty;
        }
        return testSeed;
    }

    private static void throwInvalidJavaHomeException(String description, File javaHome, int expectedVersion, int actualVersion) {
        String message = String.format(Locale.ROOT, "The %s must be set to a JDK installation directory for Java %d but is [%s] corresponding to [%s]", description, expectedVersion, javaHome, actualVersion);
        throw new GradleException(message);
    }

    private static File findCompilerJavaHome() {
        String compilerJavaHome = System.getenv("JAVA_HOME");
        String compilerJavaProperty = System.getProperty("compiler.java");
        if (compilerJavaProperty != null) {
            compilerJavaHome = GlobalBuildInfoPlugin.findJavaHome(compilerJavaProperty);
        }
        return compilerJavaHome == null ? Jvm.current().getJavaHome() : new File(compilerJavaHome);
    }

    private static File findRuntimeJavaHome(File compilerJavaHome) {
        String runtimeJavaProperty = System.getProperty("runtime.java");
        if (runtimeJavaProperty != null) {
            return new File(GlobalBuildInfoPlugin.findJavaHome(runtimeJavaProperty));
        }
        return System.getenv("RUNTIME_JAVA_HOME") == null ? compilerJavaHome : new File(System.getenv("RUNTIME_JAVA_HOME"));
    }

    private static String findJavaHome(String version) {
        String versionedJavaHome = System.getenv(GlobalBuildInfoPlugin.getJavaHomeEnvVarName(version));
        if (versionedJavaHome == null) {
            String exceptionMessage = String.format(Locale.ROOT, "$%s must be set to build Elasticsearch. Note that if the variable was just set you might have to run `./gradlew --stop` for it to be picked up. See https://github.com/elastic/elasticsearch/issues/31399 details.", GlobalBuildInfoPlugin.getJavaHomeEnvVarName(version));
            throw new GradleException(exceptionMessage);
        }
        return versionedJavaHome;
    }

    private static String getJavaHomeEnvVarName(String version) {
        return "JAVA" + version + "_HOME";
    }

    private static int findDefaultParallel(Project project) {
        if (_defaultParallel == null) {
            File cpuInfoFile = new File("/proc/cpuinfo");
            if (cpuInfoFile.exists()) {
                HashMap<String, Integer> socketToCore = new HashMap<String, Integer>();
                String currentID = "";
                try (BufferedReader reader = new BufferedReader(new FileReader(cpuInfoFile));){
                    String line = reader.readLine();
                    while (line != null) {
                        if (line.contains(":")) {
                            List parts = Arrays.stream(line.split(":", 2)).map(String::trim).collect(Collectors.toList());
                            String name = (String)parts.get(0);
                            String value = (String)parts.get(1);
                            if (name.equals("physical id")) {
                                currentID = value;
                            }
                            if (name.equals("cpu cores")) {
                                assert (!currentID.isEmpty());
                                socketToCore.put("currentID", Integer.valueOf(value));
                                currentID = "";
                            }
                        }
                        line = reader.readLine();
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                _defaultParallel = socketToCore.values().stream().mapToInt(i -> i).sum();
            } else if (OS.current() == OS.MAC) {
                ByteArrayOutputStream stdout = new ByteArrayOutputStream();
                project.exec(spec -> {
                    spec.setExecutable("sysctl");
                    spec.args(new Object[]{"-n", "hw.physicalcpu"});
                    spec.setStandardOutput((OutputStream)stdout);
                });
                _defaultParallel = Integer.parseInt(stdout.toString().trim());
            }
            _defaultParallel = Runtime.getRuntime().availableProcessors() / 2;
        }
        return _defaultParallel;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GitInfo gitInfo(File rootDir) {
        try {
            String revision;
            Path gitDir;
            Path head;
            Path dotGit = rootDir.toPath().resolve(".git");
            if (!Files.exists(dotGit, new LinkOption[0])) {
                return new GitInfo("unknown", "unknown");
            }
            if (Files.isDirectory(dotGit, new LinkOption[0])) {
                head = dotGit.resolve("HEAD");
                gitDir = dotGit;
            } else {
                Path workTree = Paths.get(GlobalBuildInfoPlugin.readFirstLine(dotGit).substring("gitdir:".length()).trim(), new String[0]);
                if (!Files.exists(workTree, new LinkOption[0])) {
                    return new GitInfo("unknown", "unknown");
                }
                head = workTree.resolve("HEAD");
                Path commonDir = Paths.get(GlobalBuildInfoPlugin.readFirstLine(workTree.resolve("commondir")), new String[0]);
                gitDir = commonDir.isAbsolute() ? commonDir : workTree.resolve(commonDir);
            }
            String ref = GlobalBuildInfoPlugin.readFirstLine(head);
            if (ref.startsWith("ref:")) {
                String refName = ref.substring("ref:".length()).trim();
                Path refFile = gitDir.resolve(refName);
                if (Files.exists(refFile, new LinkOption[0])) {
                    revision = GlobalBuildInfoPlugin.readFirstLine(refFile);
                    return new GitInfo(revision, GlobalBuildInfoPlugin.findOriginUrl(gitDir.resolve("config")));
                } else {
                    if (!Files.exists(gitDir.resolve("packed-refs"), new LinkOption[0])) throw new GradleException("Can't find revision for refName " + refName);
                    Pattern p = Pattern.compile("^([a-f0-9]{40}) " + refName + "$");
                    try (Stream<String> lines = Files.lines(gitDir.resolve("packed-refs"));){
                        revision = lines.map(p::matcher).filter(Matcher::matches).map(m -> m.group(1)).findFirst().orElseThrow(() -> new IOException("Packed reference not found for refName " + refName));
                        return new GitInfo(revision, GlobalBuildInfoPlugin.findOriginUrl(gitDir.resolve("config")));
                    }
                }
            } else {
                revision = ref;
            }
            return new GitInfo(revision, GlobalBuildInfoPlugin.findOriginUrl(gitDir.resolve("config")));
        }
        catch (IOException e) {
            throw new GradleException("unable to read the git revision", (Throwable)e);
        }
    }

    private static String findOriginUrl(Path configFile) throws IOException {
        String originUrl;
        HashMap<String, String> props = new HashMap<String, String>();
        try (Stream<String> stream = Files.lines(configFile, StandardCharsets.UTF_8);){
            Iterator lines = stream.iterator();
            boolean foundOrigin = false;
            while (lines.hasNext()) {
                String line = ((String)lines.next()).trim();
                if (line.startsWith(";") || line.startsWith("#")) continue;
                if (foundOrigin) {
                    if (line.startsWith("[")) {
                        break;
                    }
                    String[] pair = line.trim().split("=");
                    props.put(pair[0].trim(), pair[1].trim());
                    continue;
                }
                if (!line.equals("[remote \"origin\"]")) continue;
                foundOrigin = true;
            }
        }
        return (originUrl = (String)props.get("url")) == null ? "unknown" : originUrl;
    }

    private static String readFirstLine(Path path) throws IOException {
        String firstLine;
        try (Stream<String> lines = Files.lines(path, StandardCharsets.UTF_8);){
            firstLine = lines.findFirst().orElseThrow(() -> new IOException("file [" + path + "] is empty"));
        }
        return firstLine;
    }

    private static class GitInfo {
        private final String revision;
        private final String origin;

        GitInfo(String revision, String origin) {
            this.revision = revision;
            this.origin = origin;
        }

        public String getRevision() {
            return this.revision;
        }

        public String getOrigin() {
            return this.origin;
        }
    }
}

