/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle.info;

import java.io.File;
import java.lang.reflect.Modifier;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.elasticsearch.gradle.info.JavaHome;
import org.gradle.api.JavaVersion;

public class BuildParams {
    private static File compilerJavaHome;
    private static File runtimeJavaHome;
    private static Boolean isRuntimeJavaHomeSet;
    private static List<JavaHome> javaVersions;
    private static JavaVersion minimumCompilerVersion;
    private static JavaVersion minimumRuntimeVersion;
    private static JavaVersion gradleJavaVersion;
    private static JavaVersion compilerJavaVersion;
    private static JavaVersion runtimeJavaVersion;
    private static Boolean inFipsJvm;
    private static String gitRevision;
    private static String gitOrigin;
    private static ZonedDateTime buildDate;
    private static String testSeed;
    private static Boolean isCi;
    private static Boolean isInternal;
    private static Integer defaultParallel;
    private static Boolean isSnapshotBuild;

    public static void init(Consumer<MutableBuildParams> initializer) {
        initializer.accept(MutableBuildParams.INSTANCE);
    }

    public static File getCompilerJavaHome() {
        return BuildParams.value(compilerJavaHome);
    }

    public static File getRuntimeJavaHome() {
        return BuildParams.value(runtimeJavaHome);
    }

    public static Boolean getIsRuntimeJavaHomeSet() {
        return BuildParams.value(isRuntimeJavaHomeSet);
    }

    public static List<JavaHome> getJavaVersions() {
        return BuildParams.value(javaVersions);
    }

    public static JavaVersion getMinimumCompilerVersion() {
        return BuildParams.value(minimumCompilerVersion);
    }

    public static JavaVersion getMinimumRuntimeVersion() {
        return BuildParams.value(minimumRuntimeVersion);
    }

    public static JavaVersion getGradleJavaVersion() {
        return BuildParams.value(gradleJavaVersion);
    }

    public static JavaVersion getCompilerJavaVersion() {
        return BuildParams.value(compilerJavaVersion);
    }

    public static JavaVersion getRuntimeJavaVersion() {
        return BuildParams.value(runtimeJavaVersion);
    }

    public static Boolean isInFipsJvm() {
        return BuildParams.value(inFipsJvm);
    }

    public static String getGitRevision() {
        return BuildParams.value(gitRevision);
    }

    public static String getGitOrigin() {
        return BuildParams.value(gitOrigin);
    }

    public static ZonedDateTime getBuildDate() {
        return BuildParams.value(buildDate);
    }

    public static String getTestSeed() {
        return BuildParams.value(testSeed);
    }

    public static Boolean isCi() {
        return BuildParams.value(isCi);
    }

    public static Boolean isInternal() {
        return BuildParams.value(isInternal);
    }

    public static Integer getDefaultParallel() {
        return BuildParams.value(defaultParallel);
    }

    public static boolean isSnapshotBuild() {
        return BuildParams.value(isSnapshotBuild);
    }

    private static <T> T value(T object) {
        if (object == null) {
            String callingMethod = Thread.currentThread().getStackTrace()[2].getMethodName();
            throw new IllegalStateException("Build parameter '" + BuildParams.propertyName(callingMethod) + "' has not been initialized.\nPerhaps the plugin responsible for initializing this property has not been applied.");
        }
        return object;
    }

    private static String propertyName(String methodName) {
        String propertyName = methodName.startsWith("is") ? methodName.substring("is".length()) : methodName.substring("get".length());
        return propertyName.substring(0, 1).toLowerCase() + propertyName.substring(1);
    }

    public static class MutableBuildParams {
        private static MutableBuildParams INSTANCE = new MutableBuildParams();

        private MutableBuildParams() {
        }

        public void reset() {
            Arrays.stream(BuildParams.class.getDeclaredFields()).filter(f -> Modifier.isStatic(f.getModifiers())).forEach(f -> {
                try {
                    f.setAccessible(true);
                    f.set(null, null);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            });
        }

        public void setCompilerJavaHome(File compilerJavaHome) {
            compilerJavaHome = Objects.requireNonNull(compilerJavaHome);
        }

        public void setRuntimeJavaHome(File runtimeJavaHome) {
            runtimeJavaHome = Objects.requireNonNull(runtimeJavaHome);
        }

        public void setIsRutimeJavaHomeSet(boolean isRutimeJavaHomeSet) {
            isRuntimeJavaHomeSet = isRutimeJavaHomeSet;
        }

        public void setJavaVersions(List<JavaHome> javaVersions) {
            javaVersions = Objects.requireNonNull(javaVersions);
        }

        public void setMinimumCompilerVersion(JavaVersion minimumCompilerVersion) {
            minimumCompilerVersion = Objects.requireNonNull(minimumCompilerVersion);
        }

        public void setMinimumRuntimeVersion(JavaVersion minimumRuntimeVersion) {
            minimumRuntimeVersion = Objects.requireNonNull(minimumRuntimeVersion);
        }

        public void setGradleJavaVersion(JavaVersion gradleJavaVersion) {
            gradleJavaVersion = Objects.requireNonNull(gradleJavaVersion);
        }

        public void setCompilerJavaVersion(JavaVersion compilerJavaVersion) {
            compilerJavaVersion = Objects.requireNonNull(compilerJavaVersion);
        }

        public void setRuntimeJavaVersion(JavaVersion runtimeJavaVersion) {
            runtimeJavaVersion = Objects.requireNonNull(runtimeJavaVersion);
        }

        public void setInFipsJvm(boolean inFipsJvm) {
            inFipsJvm = inFipsJvm;
        }

        public void setGitRevision(String gitRevision) {
            gitRevision = Objects.requireNonNull(gitRevision);
        }

        public void setGitOrigin(String gitOrigin) {
            gitOrigin = Objects.requireNonNull(gitOrigin);
        }

        public void setBuildDate(ZonedDateTime buildDate) {
            buildDate = Objects.requireNonNull(buildDate);
        }

        public void setTestSeed(String testSeed) {
            testSeed = Objects.requireNonNull(testSeed);
        }

        public void setIsCi(boolean isCi) {
            isCi = isCi;
        }

        public void setIsInternal(Boolean isInternal) {
            isInternal = Objects.requireNonNull(isInternal);
        }

        public void setDefaultParallel(int defaultParallel) {
            defaultParallel = defaultParallel;
        }

        public void setIsSnapshotBuild(boolean isSnapshotBuild) {
            isSnapshotBuild = isSnapshotBuild;
        }
    }
}

