/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle.docker;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.elasticsearch.gradle.Version;
import org.elasticsearch.gradle.info.BuildParams;
import org.gradle.api.GradleException;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.process.ExecOperations;
import org.gradle.process.ExecResult;

public abstract class DockerSupportService
implements BuildService<Parameters> {
    private static Logger LOGGER = Logging.getLogger(DockerSupportService.class);
    private static String[] DOCKER_BINARIES = new String[]{"/usr/bin/docker", "/usr/local/bin/docker"};
    private static String[] DOCKER_COMPOSE_BINARIES = new String[]{"/usr/local/bin/docker-compose", "/usr/bin/docker-compose"};
    private static final Version MINIMUM_DOCKER_VERSION = Version.fromString("17.05.0");
    private final ExecOperations execOperations;
    private DockerAvailability dockerAvailability;

    @Inject
    public DockerSupportService(ExecOperations execOperations) {
        this.execOperations = execOperations;
    }

    public DockerAvailability getDockerAvailability() {
        if (this.dockerAvailability == null) {
            String dockerPath = null;
            Result lastResult = null;
            Version version = null;
            boolean isVersionHighEnough = false;
            boolean isComposeAvailable = false;
            Optional<String> dockerBinary = this.getDockerPath();
            if (!this.isExcludedOs() && dockerBinary.isPresent() && (lastResult = this.runCommand(dockerPath = dockerBinary.get(), "version", "--format", "{{.Server.Version}}")).isSuccess() && (isVersionHighEnough = (version = Version.fromString(lastResult.stdout.trim(), Version.Mode.RELAXED)).onOrAfter(MINIMUM_DOCKER_VERSION))) {
                lastResult = this.runCommand(dockerPath, "images");
                Optional<String> composePath = this.getDockerComposePath();
                if (lastResult.isSuccess() && composePath.isPresent()) {
                    isComposeAvailable = this.runCommand(composePath.get(), "version").isSuccess();
                }
            }
            boolean isAvailable = isVersionHighEnough && lastResult != null && lastResult.isSuccess();
            this.dockerAvailability = new DockerAvailability(isAvailable, isComposeAvailable, isVersionHighEnough, dockerPath, version, lastResult);
        }
        return this.dockerAvailability;
    }

    void failIfDockerUnavailable(List<String> tasks) {
        String message;
        DockerAvailability availability = this.getDockerAvailability();
        if (availability.isAvailable) {
            return;
        }
        if (availability.path == null) {
            message = String.format(Locale.ROOT, "Docker (checked [%s]) is required to run the following task%s: \n%s", String.join((CharSequence)", ", DOCKER_BINARIES), tasks.size() > 1 ? "s" : "", String.join((CharSequence)"\n", tasks));
            this.throwDockerRequiredException(message);
        }
        if (availability.lastCommand.isSuccess() && !availability.isVersionHighEnough) {
            message = String.format(Locale.ROOT, "building Docker images requires minimum Docker version of %s due to use of multi-stage builds yet was [%s]", MINIMUM_DOCKER_VERSION, availability.version);
            this.throwDockerRequiredException(message);
        }
        message = String.format(Locale.ROOT, "a problem occurred while using Docker from [%s]%s yet it is required to run the following task%s: \n%s\nthe problem is that Docker exited with exit code [%d] with standard error output:\n%s", availability.path, availability.version == null ? "" : " v" + availability.version, tasks.size() > 1 ? "s" : "", String.join((CharSequence)"\n", tasks), availability.lastCommand.exitCode, availability.lastCommand.stderr.trim());
        this.throwDockerRequiredException(message);
    }

    private boolean isExcludedOs() {
        if (!BuildParams.isCi().booleanValue()) {
            return false;
        }
        Path osRelease = Paths.get("/etc/os-release", new String[0]);
        if (Files.exists(osRelease, new LinkOption[0])) {
            Map<String, String> values;
            try {
                List<String> osReleaseLines = Files.readAllLines(osRelease);
                values = DockerSupportService.parseOsRelease(osReleaseLines);
            }
            catch (IOException e) {
                throw new GradleException("Failed to read /etc/os-release", (Throwable)e);
            }
            String id = DockerSupportService.deriveId(values);
            boolean excluded = this.getLinuxExclusionList().contains(id);
            if (excluded) {
                LOGGER.warn("Linux OS id [{}] is present in the Docker exclude list. Tasks requiring Docker will be disabled.", (Object)id);
            }
            return excluded;
        }
        return false;
    }

    private List<String> getLinuxExclusionList() {
        File exclusionsFile = ((Parameters)this.getParameters()).getExclusionsFile();
        if (exclusionsFile.exists()) {
            try {
                return Files.readAllLines(exclusionsFile.toPath()).stream().map(String::trim).filter(line -> !(line.isEmpty() || line.startsWith("#"))).collect(Collectors.toList());
            }
            catch (IOException e) {
                throw new GradleException("Failed to read " + exclusionsFile.getAbsolutePath(), (Throwable)e);
            }
        }
        return Collections.emptyList();
    }

    static String deriveId(Map<String, String> values) {
        return values.get("ID") + "-" + values.get("VERSION_ID");
    }

    static Map<String, String> parseOsRelease(List<String> osReleaseLines) {
        HashMap<String, String> values = new HashMap<String, String>();
        osReleaseLines.stream().map(String::trim).filter(line -> !(line.isEmpty() || line.startsWith("#"))).forEach(line -> {
            String[] parts = line.split("=", 2);
            String key = parts[0];
            String value = parts[1].replaceAll("^['\"]?\\s*", "").replaceAll("\\s*['\"]?$", "");
            values.put(key, value.toLowerCase());
        });
        return values;
    }

    private Optional<String> getDockerPath() {
        return List.of(DOCKER_BINARIES).stream().filter(path -> new File((String)path).exists()).findFirst();
    }

    private Optional<String> getDockerComposePath() {
        return List.of(DOCKER_COMPOSE_BINARIES).stream().filter(path -> new File((String)path).exists()).findFirst();
    }

    private void throwDockerRequiredException(String message) {
        this.throwDockerRequiredException(message, null);
    }

    private void throwDockerRequiredException(String message, Exception e) {
        throw new GradleException(message + "\nyou can address this by attending to the reported issue, or removing the offending tasks from being executed.", (Throwable)e);
    }

    private Result runCommand(String ... args) {
        if (args.length == 0) {
            throw new IllegalArgumentException("Cannot execute with no command");
        }
        ByteArrayOutputStream stdout = new ByteArrayOutputStream();
        ByteArrayOutputStream stderr = new ByteArrayOutputStream();
        ExecResult execResult = this.execOperations.exec(spec -> {
            spec.setCommandLine((Object[])args);
            spec.setStandardOutput((OutputStream)stdout);
            spec.setErrorOutput((OutputStream)stderr);
            spec.setIgnoreExitValue(true);
        });
        return new Result(execResult.getExitValue(), stdout.toString(), stderr.toString());
    }

    public static class DockerAvailability {
        public final boolean isAvailable;
        public final boolean isComposeAvailable;
        public final boolean isVersionHighEnough;
        public final String path;
        public final Version version;
        final Result lastCommand;

        DockerAvailability(boolean isAvailable, boolean isComposeAvailable, boolean isVersionHighEnough, String path, Version version, Result lastCommand) {
            this.isAvailable = isAvailable;
            this.isComposeAvailable = isComposeAvailable;
            this.isVersionHighEnough = isVersionHighEnough;
            this.path = path;
            this.version = version;
            this.lastCommand = lastCommand;
        }
    }

    private static class Result {
        final int exitCode;
        final String stdout;
        final String stderr;

        Result(int exitCode, String stdout, String stderr) {
            this.exitCode = exitCode;
            this.stdout = stdout;
            this.stderr = stderr;
        }

        boolean isSuccess() {
            return this.exitCode == 0;
        }

        public String toString() {
            return "exitCode = [" + this.exitCode + "] stdout = [" + this.stdout.trim() + "] stderr = [" + this.stderr.trim() + "]";
        }
    }

    static interface Parameters
    extends BuildServiceParameters {
        public File getExclusionsFile();

        public void setExclusionsFile(File var1);
    }
}

