/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle.docker;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import org.elasticsearch.gradle.LoggedExec;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.ExecOperations;
import org.gradle.process.ExecSpec;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.WorkerExecutor;

public class DockerBuildTask
extends DefaultTask {
    private final WorkerExecutor workerExecutor;
    private final RegularFileProperty markerFile = this.getProject().getObjects().fileProperty();
    private final DirectoryProperty dockerContext = this.getProject().getObjects().directoryProperty();
    private String[] tags;
    private boolean pull = true;
    private boolean noCache = true;

    @Inject
    public DockerBuildTask(WorkerExecutor workerExecutor) {
        this.workerExecutor = workerExecutor;
        this.markerFile.set(this.getProject().getLayout().getBuildDirectory().file("markers/" + this.getName() + ".marker"));
    }

    @TaskAction
    public void build() {
        this.workerExecutor.noIsolation().submit(DockerBuildAction.class, params -> {
            params.getDockerContext().set((Provider)this.dockerContext);
            params.getMarkerFile().set((Provider)this.markerFile);
            params.getTags().set(Arrays.asList(this.tags));
            params.getPull().set((Object)this.pull);
            params.getNoCache().set((Object)this.noCache);
        });
    }

    @InputDirectory
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public DirectoryProperty getDockerContext() {
        return this.dockerContext;
    }

    @Input
    public String[] getTags() {
        return this.tags;
    }

    public void setTags(String[] tags) {
        this.tags = tags;
    }

    @Input
    public boolean isPull() {
        return this.pull;
    }

    public void setPull(boolean pull) {
        this.pull = pull;
    }

    @Input
    public boolean isNoCache() {
        return this.noCache;
    }

    public void setNoCache(boolean noCache) {
        this.noCache = noCache;
    }

    @OutputFile
    public RegularFileProperty getMarkerFile() {
        return this.markerFile;
    }

    public static abstract class DockerBuildAction
    implements WorkAction<Parameters> {
        private final ExecOperations execOperations;

        @Inject
        public DockerBuildAction(ExecOperations execOperations) {
            this.execOperations = execOperations;
        }

        public void execute() {
            LoggedExec.exec(this.execOperations, (Action<ExecSpec>)((Action)spec -> {
                spec.executable((Object)"docker");
                spec.args(new Object[]{"build", ((Directory)((Parameters)this.getParameters()).getDockerContext().get()).getAsFile().getAbsolutePath()});
                if (((Boolean)((Parameters)this.getParameters()).getPull().get()).booleanValue()) {
                    spec.args(new Object[]{"--pull"});
                }
                if (((Boolean)((Parameters)this.getParameters()).getNoCache().get()).booleanValue()) {
                    spec.args(new Object[]{"--no-cache"});
                }
                ((List)((Parameters)this.getParameters()).getTags().get()).forEach(tag -> spec.args(new Object[]{"--tag", tag}));
            }));
            try {
                ((File)((Parameters)this.getParameters()).getMarkerFile().getAsFile().get()).createNewFile();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to create marker file", e);
            }
        }
    }

    static interface Parameters
    extends WorkParameters {
        public DirectoryProperty getDockerContext();

        public RegularFileProperty getMarkerFile();

        public ListProperty<String> getTags();

        public Property<Boolean> getPull();

        public Property<Boolean> getNoCache();
    }
}

