/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle.checkstyle;

import com.puppycrawl.tools.checkstyle.api.AbstractFileSetCheck;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.FileText;
import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SnippetLengthCheck
extends AbstractFileSetCheck {
    private static final Pattern START = Pattern.compile("^( *)//\\s*tag::(.+?)\\s*$", 8);
    private int max;

    public void setMax(int max) {
        this.max = max;
    }

    protected void processFiltered(File file, FileText fileText) throws CheckstyleException {
        SnippetLengthCheck.checkFile((line, message) -> this.log((int)line, (String)message, new Object[0]), this.max, fileText.toLinesArray());
    }

    static void checkFile(BiConsumer<Integer, String> log, int max, String ... lineArray) {
        LineItr lines = new LineItr(Arrays.asList(lineArray).iterator());
        while (lines.hasNext()) {
            Matcher m = START.matcher(lines.next());
            if (!m.matches()) continue;
            SnippetLengthCheck.checkSnippet(log, max, lines, m.group(1), m.group(2));
        }
    }

    private static void checkSnippet(BiConsumer<Integer, String> log, int max, LineItr lines, String leadingSpaces, String name) {
        Pattern end = Pattern.compile("^ *//\\s*end::" + name + "\\s*$", 8);
        while (lines.hasNext()) {
            String line = lines.next();
            if (end.matcher(line).matches()) {
                return;
            }
            if (line.isEmpty()) continue;
            if (!line.startsWith(leadingSpaces)) {
                log.accept(lines.lastLineNumber, "snippet line should start with [" + leadingSpaces + "]");
                continue;
            }
            int width = line.length() - leadingSpaces.length();
            if (width <= max) continue;
            log.accept(lines.lastLineNumber, "snippet line should be no more than [" + max + "] characters but was [" + width + "]");
        }
    }

    private static class LineItr
    implements Iterator<String> {
        private final Iterator<String> delegate;
        private int lastLineNumber;

        LineItr(Iterator<String> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public String next() {
            ++this.lastLineNumber;
            return this.delegate.next();
        }
    }
}

