/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle;

import java.nio.file.Path;
import org.elasticsearch.gradle.ReaperService;
import org.elasticsearch.gradle.info.GlobalBuildInfoPlugin;
import org.gradle.api.Plugin;
import org.gradle.api.Project;

public class ReaperPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        if (project != project.getRootProject()) {
            throw new IllegalArgumentException("ReaperPlugin can only be applied to the root project of a build");
        }
        project.getPlugins().apply(GlobalBuildInfoPlugin.class);
        Path inputDir = project.getRootDir().toPath().resolve(".gradle").resolve("reaper").resolve("build-" + ProcessHandle.current().pid());
        ReaperService service = (ReaperService)project.getExtensions().create("reaper", ReaperService.class, new Object[]{project, project.getBuildDir().toPath(), inputDir});
        project.getGradle().buildFinished(result -> service.shutdown());
    }
}

