/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.elasticsearch.gradle.AbstractLazyPropertyCollection;
import org.elasticsearch.gradle.PropertyNormalization;
import org.gradle.api.tasks.Input;

public class LazyPropertyList<T>
extends AbstractLazyPropertyCollection
implements List<T> {
    private final List<PropertyListEntry<T>> delegate = new ArrayList<PropertyListEntry<T>>();

    public LazyPropertyList(String name) {
        super(name);
    }

    public LazyPropertyList(String name, Object owner) {
        super(name, owner);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.delegate.stream().anyMatch(entry -> entry.getValue().equals(o));
    }

    @Override
    public Iterator<T> iterator() {
        return this.delegate.stream().peek(this::validate).map(PropertyListEntry::getValue).iterator();
    }

    @Override
    public Object[] toArray() {
        return this.delegate.stream().peek(this::validate).map(PropertyListEntry::getValue).toArray();
    }

    @Override
    public <T1> T1[] toArray(T1[] a) {
        return this.delegate.stream().peek(this::validate).map(PropertyListEntry::getValue).collect(Collectors.toList()).toArray(a);
    }

    @Override
    public boolean add(T t) {
        return this.delegate.add(new PropertyListEntry<Object>(() -> t, PropertyNormalization.DEFAULT));
    }

    @Override
    public boolean add(Supplier<T> supplier) {
        return this.delegate.add(new PropertyListEntry<T>(supplier, PropertyNormalization.DEFAULT));
    }

    public boolean add(Supplier<T> supplier, PropertyNormalization normalization) {
        return this.delegate.add(new PropertyListEntry<T>(supplier, normalization));
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support remove()");
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.delegate.stream().map(PropertyListEntry::getValue).collect(Collectors.toList()).containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        c.forEach(this::add);
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        int i = index;
        for (T item : c) {
            this.add(i++, item);
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support removeAll()");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support retainAll()");
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public T get(int index) {
        PropertyListEntry<T> entry = this.delegate.get(index);
        this.validate(entry);
        return entry.getValue();
    }

    @Override
    public T set(int index, T element) {
        return (T)this.delegate.set(index, new PropertyListEntry<Object>(() -> element, PropertyNormalization.DEFAULT)).getValue();
    }

    @Override
    public void add(int index, T element) {
        this.delegate.add(index, new PropertyListEntry<Object>(() -> element, PropertyNormalization.DEFAULT));
    }

    @Override
    public T remove(int index) {
        return this.delegate.remove(index).getValue();
    }

    @Override
    public int indexOf(Object o) {
        for (int i = 0; i < this.delegate.size(); ++i) {
            if (!this.delegate.get(i).getValue().equals(o)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        int lastIndex = -1;
        for (int i = 0; i < this.delegate.size(); ++i) {
            if (!this.delegate.get(i).getValue().equals(o)) continue;
            lastIndex = i;
        }
        return lastIndex;
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.delegate.stream().map(PropertyListEntry::getValue).collect(Collectors.toList()).listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return this.delegate.stream().peek(this::validate).map(PropertyListEntry::getValue).collect(Collectors.toList()).listIterator(index);
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return this.delegate.stream().peek(this::validate).map(PropertyListEntry::getValue).collect(Collectors.toList()).subList(fromIndex, toIndex);
    }

    public List<? extends PropertyListEntry<T>> getNormalizedCollection() {
        return this.delegate.stream().peek(this::validate).filter(entry -> entry.getNormalization() != PropertyNormalization.IGNORE_VALUE).collect(Collectors.toList());
    }

    public List<? extends T> getFlatNormalizedCollection() {
        return this.getNormalizedCollection().stream().map(PropertyListEntry::getValue).collect(Collectors.toList());
    }

    private void validate(PropertyListEntry<T> entry) {
        this.assertNotNull(entry.getValue(), "entry");
    }

    private class PropertyListEntry<T> {
        private final Supplier<T> supplier;
        private final PropertyNormalization normalization;

        PropertyListEntry(Supplier<T> supplier, PropertyNormalization normalization) {
            this.supplier = supplier;
            this.normalization = normalization;
        }

        public PropertyNormalization getNormalization() {
            return this.normalization;
        }

        @Input
        public T getValue() {
            LazyPropertyList.this.assertNotNull(this.supplier, "supplier");
            return this.supplier.get();
        }
    }
}

