/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.stream.StreamSupport;
import org.elasticsearch.gradle.Jdk;
import org.elasticsearch.gradle.tar.SymbolicLinkPreservingUntarTask;
import org.elasticsearch.gradle.util.GradleUtils;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.artifacts.repositories.IvyArtifactRepository;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.RelativePath;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.TaskProvider;

public class JdkDownloadPlugin
implements Plugin<Project> {
    private static final String REPO_NAME_PREFIX = "jdk_repo_";
    private static final String EXTENSION_NAME = "jdks";

    public void apply(Project project) {
        NamedDomainObjectContainer jdksContainer = project.container(Jdk.class, name -> new Jdk(name, (Configuration)project.getConfigurations().create("jdk_" + name), project.getObjects()));
        project.getExtensions().add(EXTENSION_NAME, (Object)jdksContainer);
        project.afterEvaluate(p -> {
            for (Jdk jdk : jdksContainer) {
                jdk.finalizeValues();
                DependencyHandler dependencies = project.getDependencies();
                HashMap<String, String> depConfig = new HashMap<String, String>();
                depConfig.put("path", ":");
                depConfig.put("configuration", JdkDownloadPlugin.configName("extracted_jdk", jdk.getVendor(), jdk.getVersion(), jdk.getPlatform(), jdk.getArchitecture()));
                project.getDependencies().add(jdk.getConfigurationName(), (Object)dependencies.project(depConfig));
                JdkDownloadPlugin.setupRootJdkDownload(project.getRootProject(), jdk);
            }
        });
    }

    public static NamedDomainObjectContainer<Jdk> getContainer(Project project) {
        return (NamedDomainObjectContainer)project.getExtensions().getByName(EXTENSION_NAME);
    }

    private static void setupRootJdkDownload(Project rootProject, Jdk jdk) {
        String extractTaskName = String.format(Locale.ROOT, "extract-%s-%s-jdk-%s-%s", jdk.getPlatform(), jdk.getArchitecture(), jdk.getVendor(), jdk.getVersion());
        if (GradleUtils.findByName(rootProject.getTasks(), extractTaskName) == null) {
            String artifactPattern;
            String repoUrl;
            RepositoryHandler repositories = rootProject.getRepositories();
            String repoName = REPO_NAME_PREFIX + jdk.getVendor() + "_" + jdk.getVersion();
            if (jdk.getVendor().equals("adoptopenjdk")) {
                repoUrl = "https://api.adoptopenjdk.net/v3/binary/version/";
                artifactPattern = jdk.getMajor().equals("8") ? "jdk" + jdk.getBaseVersion() + "-" + jdk.getBuild() + "/[module]/[classifier]/jdk/hotspot/normal/adoptopenjdk" : "jdk-" + jdk.getBaseVersion() + "+" + jdk.getBuild() + "/[module]/[classifier]/jdk/hotspot/normal/adoptopenjdk";
            } else if (jdk.getVendor().equals("openjdk")) {
                repoUrl = "https://download.oracle.com";
                artifactPattern = jdk.getHash() != null ? "java/GA/jdk" + jdk.getBaseVersion() + "/" + jdk.getHash() + "/" + jdk.getBuild() + "/GPL/openjdk-[revision]_[module]-[classifier]_bin.[ext]" : "java/GA/jdk" + jdk.getMajor() + "/" + jdk.getBuild() + "/GPL/openjdk-[revision]_[module]-[classifier]_bin.[ext]";
            } else {
                throw new GradleException("Unknown JDK vendor [" + jdk.getVendor() + "]");
            }
            if (repositories.findByName(repoName) == null) {
                IvyArtifactRepository ivyRepo = repositories.ivy(repo -> {
                    repo.setName(repoName);
                    repo.setUrl((Object)repoUrl);
                    repo.metadataSources(IvyArtifactRepository.MetadataSources::artifact);
                    repo.patternLayout(layout -> layout.artifact(artifactPattern));
                });
                repositories.exclusiveContent(exclusiveContentRepository -> {
                    exclusiveContentRepository.forRepositories(new ArtifactRepository[]{ivyRepo});
                    exclusiveContentRepository.filter(config -> config.includeGroup(JdkDownloadPlugin.groupName(jdk)));
                });
            }
            ConfigurationContainer configurations = rootProject.getConfigurations();
            String downloadConfigName = JdkDownloadPlugin.configName(jdk.getVendor(), jdk.getVersion(), jdk.getPlatform(), jdk.getArchitecture());
            Configuration downloadConfiguration = (Configuration)GradleUtils.maybeCreate(configurations, downloadConfigName);
            rootProject.getDependencies().add(downloadConfigName, (Object)JdkDownloadPlugin.dependencyNotation(jdk));
            Provider extractPath = rootProject.getLayout().getBuildDirectory().dir("jdks/" + jdk.getVendor() + "-" + jdk.getBaseVersion() + "_" + jdk.getPlatform() + "_" + jdk.getArchitecture());
            TaskProvider<?> extractTask = JdkDownloadPlugin.createExtractTask(extractTaskName, rootProject, jdk.getPlatform(), downloadConfiguration, (Provider<Directory>)extractPath);
            String artifactConfigName = JdkDownloadPlugin.configName("extracted_jdk", jdk.getVendor(), jdk.getVersion(), jdk.getPlatform(), jdk.getArchitecture());
            GradleUtils.maybeCreate(configurations, artifactConfigName);
            rootProject.getArtifacts().add(artifactConfigName, (Object)extractPath, artifact -> artifact.builtBy(new Object[]{extractTask}));
        }
    }

    private static TaskProvider<?> createExtractTask(String taskName, final Project rootProject, String platform, Configuration downloadConfiguration, final Provider<Directory> extractPath) {
        if (platform.equals("windows")) {
            Callable<FileTree> fileGetter = () -> rootProject.zipTree((Object)downloadConfiguration.getSingleFile());
            Action removeRootDir = copy -> {
                copy.eachFile(details -> {
                    Path newPathSegments = JdkDownloadPlugin.trimArchiveExtractPath(details.getRelativePath().getPathString());
                    String[] segments = (String[])StreamSupport.stream(newPathSegments.spliterator(), false).map(Path::toString).toArray(String[]::new);
                    details.setRelativePath(new RelativePath(true, segments));
                });
                copy.setIncludeEmptyDirs(false);
            };
            return rootProject.getTasks().register(taskName, Copy.class, copyTask -> {
                copyTask.doFirst((Action)new Action<Task>(){

                    public void execute(Task t) {
                        rootProject.delete(new Object[]{extractPath});
                    }
                });
                copyTask.into((Object)extractPath);
                copyTask.from((Object)fileGetter, removeRootDir);
            });
        }
        return rootProject.getTasks().register(taskName, SymbolicLinkPreservingUntarTask.class, task -> {
            task.getTarFile().fileProvider(rootProject.provider(() -> ((Configuration)downloadConfiguration).getSingleFile()));
            task.getExtractPath().set(extractPath);
            task.setTransform(JdkDownloadPlugin::trimArchiveExtractPath);
        });
    }

    private static Path trimArchiveExtractPath(String relativePath) {
        int index;
        Path entryName = Paths.get(relativePath, new String[0]);
        for (index = 0; index < entryName.getNameCount() && !entryName.getName(index).toString().matches("jdk-?\\d.*"); ++index) {
        }
        if (index + 1 >= entryName.getNameCount()) {
            return null;
        }
        return entryName.subpath(index + 1, entryName.getNameCount());
    }

    private static String dependencyNotation(Jdk jdk) {
        String platformDep = jdk.getPlatform().equals("darwin") || jdk.getPlatform().equals("osx") ? (jdk.getVendor().equals("adoptopenjdk") ? "mac" : "osx") : jdk.getPlatform();
        String extension = jdk.getPlatform().equals("windows") ? "zip" : "tar.gz";
        return JdkDownloadPlugin.groupName(jdk) + ":" + platformDep + ":" + jdk.getBaseVersion() + ":" + jdk.getArchitecture() + "@" + extension;
    }

    private static String groupName(Jdk jdk) {
        return jdk.getVendor() + "_" + jdk.getMajor();
    }

    private static String configName(String ... parts) {
        return String.join((CharSequence)"_", parts);
    }
}

