/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle;

import com.github.jengelman.gradle.plugins.shadow.ShadowBasePlugin;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.elasticsearch.gradle.OS;
import org.elasticsearch.gradle.SimpleCommandLineArgumentProvider;
import org.elasticsearch.gradle.SystemPropertyCommandLineArgumentProvider;
import org.elasticsearch.gradle.info.BuildParams;
import org.elasticsearch.gradle.info.GlobalBuildInfoPlugin;
import org.elasticsearch.gradle.test.ErrorReportingTestListener;
import org.elasticsearch.gradle.util.GradleUtils;
import org.elasticsearch.gradle.util.Util;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.JavaVersion;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.ResolutionStrategy;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.compile.GroovyCompile;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.testing.Test;
import org.gradle.api.tasks.testing.TestListener;
import org.gradle.api.tasks.testing.TestOutputListener;
import org.gradle.api.tasks.testing.logging.TestLogging;
import org.gradle.internal.jvm.Jvm;

public class ElasticsearchJavaPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getRootProject().getPluginManager().apply(GlobalBuildInfoPlugin.class);
        project.getPluginManager().apply(JavaPlugin.class);
        ElasticsearchJavaPlugin.configureConfigurations(project);
        ElasticsearchJavaPlugin.configureCompile(project);
        ElasticsearchJavaPlugin.configureInputNormalization(project);
        ElasticsearchJavaPlugin.configureTestTasks(project);
    }

    public static void configureConfigurations(Project project) {
        Configuration compileOnlyConfig = project.getConfigurations().getByName("compileOnly");
        Configuration testCompileConfig = project.getConfigurations().getByName("testCompile");
        testCompileConfig.extendsFrom(new Configuration[]{compileOnlyConfig});
        if (project.getPath().startsWith(":test:fixtures") || project.getPath().equals(":build-tools")) {
            return;
        }
        project.getConfigurations().all(configuration -> {
            if (configuration.getName().endsWith("Fixture")) {
                return;
            }
            configuration.resolutionStrategy(ResolutionStrategy::failOnVersionConflict);
        });
        Consumer<String> disableTransitiveDeps = configName -> {
            Configuration config = project.getConfigurations().getByName(configName);
            config.getDependencies().all(dep -> {
                if (dep instanceof ModuleDependency && !(dep instanceof ProjectDependency) && !dep.getGroup().startsWith("org.elasticsearch")) {
                    ((ModuleDependency)dep).setTransitive(false);
                }
            });
        };
        disableTransitiveDeps.accept("compile");
        disableTransitiveDeps.accept("testCompile");
        disableTransitiveDeps.accept("compileOnly");
        disableTransitiveDeps.accept("runtimeOnly");
    }

    public static void configureCompile(Project project) {
        project.getExtensions().getExtraProperties().set("compactProfile", (Object)"full");
        JavaPluginExtension java = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
        java.setSourceCompatibility(BuildParams.getMinimumRuntimeVersion());
        java.setTargetCompatibility(BuildParams.getMinimumRuntimeVersion());
        Function<File, String> canonicalPath = file -> {
            try {
                return file.getCanonicalPath();
            }
            catch (IOException e) {
                throw new GradleException("Failed to get canonical path for " + file, (Throwable)e);
            }
        };
        Consumer<CompileOptions> configureFork = compileOptions -> {
            String currentJavaHome;
            String compilerJavaHome = (String)canonicalPath.apply(BuildParams.getCompilerJavaHome());
            if (compilerJavaHome.equals(currentJavaHome = (String)canonicalPath.apply(Jvm.current().getJavaHome()))) {
                compileOptions.setFork(false);
            } else {
                compileOptions.setFork(true);
                compileOptions.getForkOptions().setJavaHome(BuildParams.getCompilerJavaHome());
            }
        };
        project.afterEvaluate(p -> {
            project.getTasks().withType(JavaCompile.class).configureEach(compileTask -> {
                CompileOptions compileOptions = compileTask.getOptions();
                configureFork.accept(compileOptions);
                List compilerArgs = compileOptions.getCompilerArgs();
                compilerArgs.add("-Werror");
                compilerArgs.add("-Xlint:all,-path,-serial,-options,-deprecation,-try");
                compilerArgs.add("-Xdoclint:all");
                compilerArgs.add("-Xdoclint:-missing");
                if (!compilerArgs.contains("-processor")) {
                    compilerArgs.add("-proc:none");
                }
                compileOptions.setEncoding("UTF-8");
                compileOptions.setIncremental(true);
                JavaVersion targetCompatibilityVersion = JavaVersion.toVersion((Object)compileTask.getTargetCompatibility());
                compilerArgs.add("--release");
                compilerArgs.add(targetCompatibilityVersion.getMajorVersion());
            });
            project.getTasks().withType(GroovyCompile.class).configureEach(compileTask -> {
                configureFork.accept(compileTask.getOptions());
                JavaVersion targetCompatibilityVersion = JavaVersion.toVersion((Object)compileTask.getTargetCompatibility());
                List compilerArgs = compileTask.getOptions().getCompilerArgs();
                compilerArgs.add("--release");
                compilerArgs.add(targetCompatibilityVersion.getMajorVersion());
            });
        });
        project.getPluginManager().withPlugin("com.github.johnrengelman.shadow", plugin -> {
            Configuration shadowConfig = project.getConfigurations().getByName(ShadowBasePlugin.getCONFIGURATION_NAME());
            Configuration apiConfig = project.getConfigurations().getByName("apiElements");
            shadowConfig.getDependencies().all(dependency -> apiConfig.getDependencies().add(dependency));
        });
    }

    public static void configureInputNormalization(Project project) {
        project.getNormalization().getRuntimeClasspath().ignore("META-INF/MANIFEST.MF");
    }

    public static void configureTestTasks(final Project project) {
        GradleUtils.maybeConfigure(project.getTasks(), "test", Test.class, task -> task.include(new String[]{"**/*Tests.class"}));
        if (project.getPath().equals(":build-tools")) {
            return;
        }
        final File heapdumpDir = new File(project.getBuildDir(), "heapdump");
        project.getTasks().withType(Test.class).configureEach(test -> {
            final File testOutputDir = new File(test.getReports().getJunitXml().getDestination(), "output");
            ErrorReportingTestListener listener = new ErrorReportingTestListener((TestLogging)test.getTestLogging(), testOutputDir);
            test.getExtensions().add("errorReportingTestListener", (Object)listener);
            test.addTestOutputListener((TestOutputListener)listener);
            test.addTestListener((TestListener)listener);
            SystemPropertyCommandLineArgumentProvider nonInputProperties = new SystemPropertyCommandLineArgumentProvider();
            test.doFirst((Action)new Action<Task>(){

                public void execute(Task t) {
                    project.mkdir((Object)testOutputDir);
                    project.mkdir((Object)heapdumpDir);
                    project.mkdir((Object)test.getWorkingDir());
                    project.mkdir((Object)test.getWorkingDir().toPath().resolve("temp"));
                    if (BuildParams.getRuntimeJavaVersion() == JavaVersion.VERSION_1_8) {
                        test.systemProperty("java.locale.providers", (Object)"SPI,JRE");
                    } else {
                        test.systemProperty("java.locale.providers", (Object)"SPI,COMPAT");
                        test.jvmArgs(new Object[]{"--illegal-access=warn"});
                    }
                }
            });
            if (BuildParams.isInFipsJvm().booleanValue()) {
                project.getDependencies().add("testRuntimeOnly", (Object)"org.bouncycastle:bc-fips:1.0.1");
                project.getDependencies().add("testRuntimeOnly", (Object)"org.bouncycastle:bctls-fips:1.0.9");
            }
            test.getJvmArgumentProviders().add(nonInputProperties);
            test.getExtensions().add("nonInputProperties", (Object)nonInputProperties);
            test.setWorkingDir(project.file((Object)(project.getBuildDir() + "/testrun/" + test.getName())));
            test.setMaxParallelForks(Integer.parseInt(System.getProperty("tests.jvms", BuildParams.getDefaultParallel().toString())));
            test.exclude(new String[]{"**/*$*.class"});
            test.jvmArgs(new Object[]{"-Xmx" + System.getProperty("tests.heap.size", "512m"), "-Xms" + System.getProperty("tests.heap.size", "512m"), "-XX:+HeapDumpOnOutOfMemoryError"});
            test.getJvmArgumentProviders().add(new SimpleCommandLineArgumentProvider("-XX:HeapDumpPath=" + heapdumpDir));
            String argline = System.getProperty("tests.jvm.argline");
            if (argline != null) {
                test.jvmArgs((Object[])argline.split(" "));
            }
            if (Util.getBooleanProperty("tests.asserts", true)) {
                test.jvmArgs(new Object[]{"-ea", "-esa"});
            }
            Map<String, String> sysprops = Map.of("java.awt.headless", "true", "tests.gradle", "true", "tests.artifact", project.getName(), "tests.task", test.getPath(), "tests.security.manager", "true", "jna.nosys", "true");
            test.systemProperties(sysprops);
            if (System.getProperty("ignore.tests.seed") != null) {
                nonInputProperties.systemProperty("tests.seed", BuildParams.getTestSeed());
            } else {
                test.systemProperty("tests.seed", (Object)BuildParams.getTestSeed());
            }
            File gradleHome = project.getGradle().getGradleUserHomeDir();
            String gradleVersion = project.getGradle().getGradleVersion();
            nonInputProperties.systemProperty("gradle.dist.lib", new File(project.getGradle().getGradleHomeDir(), "lib"));
            nonInputProperties.systemProperty("gradle.worker.jar", gradleHome + "/caches/" + gradleVersion + "/workerMain/gradle-worker.jar");
            nonInputProperties.systemProperty("gradle.user.home", gradleHome);
            nonInputProperties.systemProperty("java.io.tmpdir", test.getWorkingDir().toPath().resolve("temp"));
            nonInputProperties.systemProperty("compiler.java", BuildParams.getCompilerJavaVersion().getMajorVersion());
            nonInputProperties.systemProperty("runtime.java", BuildParams.getRuntimeJavaVersion().getMajorVersion());
            test.systemProperty("tests.logger.level", (Object)"WARN");
            System.getProperties().entrySet().forEach(entry -> {
                if (entry.getKey().toString().startsWith("tests.") || entry.getKey().toString().startsWith("es.")) {
                    test.systemProperty(entry.getKey().toString(), entry.getValue());
                }
            });
            test.systemProperty("es.scripting.update.ctx_in_params", (Object)"false");
            test.systemProperty("es.search.rewrite_sort", (Object)"true");
            test.systemProperty("es.transport.cname_in_publish_address", (Object)"true");
            test.systemProperty("io.netty.noUnsafe", (Object)"true");
            test.systemProperty("io.netty.noKeySetOptimization", (Object)"true");
            test.systemProperty("io.netty.recycler.maxCapacityPerThread", (Object)"0");
            test.testLogging(logging -> {
                logging.setShowExceptions(true);
                logging.setShowCauses(true);
                logging.setExceptionFormat((Object)"full");
            });
            if (OS.current().equals((Object)OS.WINDOWS) && System.getProperty("tests.timeoutSuite") == null) {
                test.systemProperty("tests.timeoutSuite", (Object)"1800000!");
            }
            project.getPluginManager().withPlugin("com.github.johnrengelman.shadow", p -> {
                FileCollection mainRuntime = ((SourceSet)((SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class)).getByName("main")).getRuntimeClasspath();
                Configuration shadowConfig = project.getConfigurations().getByName(ShadowBasePlugin.getCONFIGURATION_NAME());
                ConfigurableFileCollection shadowJar = project.files(new Object[]{project.getTasks().named("shadowJar")});
                test.setClasspath(test.getClasspath().minus(mainRuntime).plus((FileCollection)shadowConfig).plus((FileCollection)shadowJar));
            });
        });
    }
}

