/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle;

import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import org.elasticsearch.gradle.Architecture;
import org.elasticsearch.gradle.OS;
import org.elasticsearch.gradle.Version;
import org.elasticsearch.gradle.VersionProperties;
import org.elasticsearch.gradle.docker.DockerSupportService;
import org.gradle.api.Buildable;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskDependency;

public class ElasticsearchDistribution
implements Buildable,
Iterable<File> {
    public static final Platform CURRENT_PLATFORM = OS.conditional().onLinux(() -> Platform.LINUX).onWindows(() -> Platform.WINDOWS).onMac(() -> Platform.DARWIN).supply();
    private final String name;
    private final Provider<DockerSupportService> dockerSupport;
    final Configuration configuration;
    private final Extracted extracted;
    private final Property<Architecture> architecture;
    private final Property<String> version;
    private final Property<Type> type;
    private final Property<Platform> platform;
    private final Property<Flavor> flavor;
    private final Property<Boolean> bundledJdk;
    private final Property<Boolean> failIfUnavailable;

    ElasticsearchDistribution(String name, ObjectFactory objectFactory, Provider<DockerSupportService> dockerSupport, Configuration fileConfiguration, Configuration extractedConfiguration) {
        this.name = name;
        this.dockerSupport = dockerSupport;
        this.configuration = fileConfiguration;
        this.architecture = objectFactory.property(Architecture.class);
        this.version = objectFactory.property(String.class).convention((Object)VersionProperties.getElasticsearch());
        this.type = objectFactory.property(Type.class);
        this.type.convention((Object)Type.ARCHIVE);
        this.platform = objectFactory.property(Platform.class);
        this.flavor = objectFactory.property(Flavor.class);
        this.bundledJdk = objectFactory.property(Boolean.class);
        this.failIfUnavailable = objectFactory.property(Boolean.class).convention((Object)true);
        this.extracted = new Extracted(extractedConfiguration);
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return (String)this.version.get();
    }

    public void setVersion(String version) {
        Version.fromString(version);
        this.version.set((Object)version);
    }

    public Platform getPlatform() {
        return (Platform)((Object)this.platform.getOrNull());
    }

    public void setPlatform(Platform platform) {
        this.platform.set((Object)platform);
    }

    public Type getType() {
        return (Type)((Object)this.type.get());
    }

    public void setType(Type type) {
        this.type.set((Object)type);
    }

    public Flavor getFlavor() {
        return (Flavor)((Object)this.flavor.getOrNull());
    }

    public void setFlavor(Flavor flavor) {
        this.flavor.set((Object)flavor);
    }

    public boolean getBundledJdk() {
        return (Boolean)this.bundledJdk.getOrElse((Object)true);
    }

    public void setBundledJdk(Boolean bundledJdk) {
        this.bundledJdk.set((Object)bundledJdk);
    }

    public boolean getFailIfUnavailable() {
        return (Boolean)this.failIfUnavailable.get();
    }

    public void setFailIfUnavailable(boolean failIfUnavailable) {
        this.failIfUnavailable.set((Object)failIfUnavailable);
    }

    public void setArchitecture(Architecture architecture) {
        this.architecture.set((Object)architecture);
    }

    public Architecture getArchitecture() {
        return (Architecture)((Object)this.architecture.get());
    }

    public String toString() {
        return this.configuration.getSingleFile().toString();
    }

    public Extracted getExtracted() {
        switch (this.getType()) {
            case DEB: 
            case DOCKER: 
            case RPM: {
                throw new UnsupportedOperationException("distribution type [" + this.getType() + "] for elasticsearch distribution [" + this.name + "] cannot be extracted");
            }
        }
        return this.extracted;
    }

    public TaskDependency getBuildDependencies() {
        if (this.getType() == Type.DOCKER && !this.getFailIfUnavailable() && !((DockerSupportService)this.dockerSupport.get()).getDockerAvailability().isAvailable) {
            return task -> Collections.emptySet();
        }
        return this.configuration.getBuildDependencies();
    }

    @Override
    public Iterator<File> iterator() {
        return this.configuration.iterator();
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    void finalizeValues() {
        if (this.getType() == Type.INTEG_TEST_ZIP) {
            if (this.platform.getOrNull() != null) {
                throw new IllegalArgumentException("platform cannot be set on elasticsearch distribution [" + this.name + "] of type [integ_test_zip]");
            }
            if (this.flavor.getOrNull() != null) {
                throw new IllegalArgumentException("flavor [" + this.flavor.get() + "] not allowed for elasticsearch distribution [" + this.name + "] of type [integ_test_zip]");
            }
            if (this.bundledJdk.getOrNull() != null) {
                throw new IllegalArgumentException("bundledJdk cannot be set on elasticsearch distribution [" + this.name + "] of type [integ_test_zip]");
            }
            return;
        }
        if (this.getType() != Type.DOCKER && !((Boolean)this.failIfUnavailable.get()).booleanValue()) {
            throw new IllegalArgumentException("failIfUnavailable cannot be 'false' on elasticsearch distribution [" + this.name + "] of type [" + this.getType() + "]");
        }
        if (this.getType() == Type.ARCHIVE) {
            if (!this.platform.isPresent()) {
                this.platform.set((Object)CURRENT_PLATFORM);
            }
        } else {
            if (this.platform.isPresent()) {
                throw new IllegalArgumentException("platform cannot be set on elasticsearch distribution [" + this.name + "] of type [" + this.getType() + "]");
            }
            if (this.getType() == Type.DOCKER && this.bundledJdk.isPresent()) {
                throw new IllegalArgumentException("bundledJdk cannot be set on elasticsearch distribution [" + this.name + "] of type [docker]");
            }
        }
        if (!this.flavor.isPresent()) {
            this.flavor.set((Object)Flavor.DEFAULT);
        }
        if (!this.bundledJdk.isPresent()) {
            this.bundledJdk.set((Object)true);
        }
        this.version.finalizeValue();
        this.platform.finalizeValue();
        this.type.finalizeValue();
        this.flavor.finalizeValue();
        this.bundledJdk.finalizeValue();
    }

    public static enum Type {
        INTEG_TEST_ZIP,
        ARCHIVE,
        RPM,
        DEB,
        DOCKER;


        public String toString() {
            return super.toString().toLowerCase(Locale.ROOT);
        }

        public boolean shouldExtract() {
            switch (this) {
                case DEB: 
                case DOCKER: 
                case RPM: {
                    return false;
                }
            }
            return true;
        }
    }

    public static enum Platform {
        LINUX,
        WINDOWS,
        DARWIN;


        public String toString() {
            return super.toString().toLowerCase(Locale.ROOT);
        }
    }

    public static enum Flavor {
        DEFAULT,
        OSS;


        public String toString() {
            return super.toString().toLowerCase(Locale.ROOT);
        }
    }

    public static final class Extracted
    implements Buildable,
    Iterable<File> {
        final Configuration configuration;

        private Extracted(Configuration configuration) {
            this.configuration = configuration;
        }

        @Override
        public Iterator<File> iterator() {
            return this.configuration.iterator();
        }

        public TaskDependency getBuildDependencies() {
            return this.configuration.getBuildDependencies();
        }

        public String toString() {
            return this.configuration.getSingleFile().toString();
        }
    }
}

