/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.geo.geometry;

import org.elasticsearch.geo.geometry.GeometryVisitor;
import org.elasticsearch.geo.geometry.Line;
import org.elasticsearch.geo.geometry.ShapeType;

public class LinearRing
extends Line {
    public static final LinearRing EMPTY = new LinearRing();

    private LinearRing() {
    }

    public LinearRing(double[] lats, double[] lons) {
        super(lats, lons);
        if (lats.length < 2) {
            throw new IllegalArgumentException("linear ring cannot contain less than 2 points, found " + lats.length);
        }
        if (lats[0] != lats[lats.length - 1] || lons[0] != lons[lons.length - 1]) {
            throw new IllegalArgumentException("first and last points of the linear ring must be the same (it must close itself): lats[0]=" + lats[0] + " lats[" + (lats.length - 1) + "]=" + lats[lats.length - 1]);
        }
    }

    @Override
    public ShapeType type() {
        return ShapeType.LINEARRING;
    }

    @Override
    public <T> T visit(GeometryVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

