/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.security;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.XContentParser;

public class NodeEnrollmentResponse {
    private final String httpCaKey;
    private final String httpCaCert;
    private final String transportKey;
    private final String transportCert;
    private final List<String> nodesAddresses;
    private static final ParseField HTTP_CA_KEY = new ParseField("http_ca_key", new String[0]);
    private static final ParseField HTTP_CA_CERT = new ParseField("http_ca_cert", new String[0]);
    private static final ParseField TRANSPORT_KEY = new ParseField("transport_key", new String[0]);
    private static final ParseField TRANSPORT_CERT = new ParseField("transport_cert", new String[0]);
    private static final ParseField NODES_ADDRESSES = new ParseField("nodes_addresses", new String[0]);
    public static final ConstructingObjectParser<NodeEnrollmentResponse, Void> PARSER = new ConstructingObjectParser(NodeEnrollmentResponse.class.getName(), true, a -> {
        String httpCaKey = (String)a[0];
        String httpCaCert = (String)a[1];
        String transportKey = (String)a[2];
        String transportCert = (String)a[3];
        List nodesAddresses = (List)a[4];
        return new NodeEnrollmentResponse(httpCaKey, httpCaCert, transportKey, transportCert, nodesAddresses);
    });

    public NodeEnrollmentResponse(String httpCaKey, String httpCaCert, String transportKey, String transportCert, List<String> nodesAddresses) {
        this.httpCaKey = httpCaKey;
        this.httpCaCert = httpCaCert;
        this.transportKey = transportKey;
        this.transportCert = transportCert;
        this.nodesAddresses = Collections.unmodifiableList(nodesAddresses);
    }

    public String getHttpCaKey() {
        return this.httpCaKey;
    }

    public String getHttpCaCert() {
        return this.httpCaCert;
    }

    public String getTransportKey() {
        return this.transportKey;
    }

    public String getTransportCert() {
        return this.transportCert;
    }

    public List<String> getNodesAddresses() {
        return this.nodesAddresses;
    }

    public static NodeEnrollmentResponse fromXContent(XContentParser parser) throws IOException {
        return (NodeEnrollmentResponse)PARSER.apply(parser, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeEnrollmentResponse that = (NodeEnrollmentResponse)o;
        return this.httpCaKey.equals(that.httpCaKey) && this.httpCaCert.equals(that.httpCaCert) && this.transportKey.equals(that.transportKey) && this.transportCert.equals(that.transportCert) && this.nodesAddresses.equals(that.nodesAddresses);
    }

    public int hashCode() {
        return Objects.hash(this.httpCaKey, this.httpCaCert, this.transportKey, this.transportCert, this.nodesAddresses);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), HTTP_CA_KEY);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), HTTP_CA_CERT);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), TRANSPORT_KEY);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), TRANSPORT_CERT);
        PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), NODES_ADDRESSES);
    }
}

