/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.security;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.XContentParser;

public final class KibanaEnrollmentResponse {
    private String tokenName;
    private SecureString tokenValue;
    private String httpCa;
    private static final ParseField TOKEN = new ParseField("token", new String[0]);
    private static final ParseField TOKEN_NAME = new ParseField("name", new String[0]);
    private static final ParseField TOKEN_VALUE = new ParseField("value", new String[0]);
    private static final ParseField HTTP_CA = new ParseField("http_ca", new String[0]);
    static final ConstructingObjectParser<Token, Void> TOKEN_PARSER = new ConstructingObjectParser(KibanaEnrollmentResponse.class.getName(), true, a -> new Token((String)a[0], (String)a[1]));
    private static final ConstructingObjectParser<KibanaEnrollmentResponse, Void> PARSER = new ConstructingObjectParser(KibanaEnrollmentResponse.class.getName(), true, a -> {
        Token token = (Token)a[0];
        return new KibanaEnrollmentResponse(token.name, new SecureString(token.value.toCharArray()), (String)a[1]);
    });

    public KibanaEnrollmentResponse(String tokenName, SecureString tokenValue, String httpCa) {
        this.tokenName = tokenName;
        this.tokenValue = tokenValue;
        this.httpCa = httpCa;
    }

    public String getTokenName() {
        return this.tokenName;
    }

    public SecureString getTokenValue() {
        return this.tokenValue;
    }

    public String getHttpCa() {
        return this.httpCa;
    }

    public static KibanaEnrollmentResponse fromXContent(XContentParser parser) throws IOException {
        return (KibanaEnrollmentResponse)PARSER.apply(parser, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KibanaEnrollmentResponse that = (KibanaEnrollmentResponse)o;
        return this.tokenName.equals(that.tokenName) && this.tokenValue.equals((Object)that.tokenValue) && this.httpCa.equals(that.httpCa);
    }

    public int hashCode() {
        return Objects.hash(this.tokenName, this.tokenValue, this.httpCa);
    }

    static {
        TOKEN_PARSER.declareString(ConstructingObjectParser.constructorArg(), TOKEN_NAME);
        TOKEN_PARSER.declareString(ConstructingObjectParser.constructorArg(), TOKEN_VALUE);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), TOKEN_PARSER, TOKEN);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), HTTP_CA);
    }

    private static class Token {
        private final String name;
        private final String value;

        Token(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }
}

