/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.security;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.client.security.user.User;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.core.Nullable;

public class GetUsersResponse {
    private final Map<String, User> users;
    private final Map<String, User> enabledUsers;
    public static final ParseField USERNAME = new ParseField("username", new String[0]);
    public static final ParseField ROLES = new ParseField("roles", new String[0]);
    public static final ParseField FULL_NAME = new ParseField("full_name", new String[0]);
    public static final ParseField EMAIL = new ParseField("email", new String[0]);
    public static final ParseField METADATA = new ParseField("metadata", new String[0]);
    public static final ParseField ENABLED = new ParseField("enabled", new String[0]);
    public static final ConstructingObjectParser<ParsedUser, String> USER_PARSER = new ConstructingObjectParser("user_info", true, constructorObjects -> {
        int i = 0;
        String username = (String)constructorObjects[i++];
        List roles = (List)constructorObjects[i++];
        Map metadata = (Map)constructorObjects[i++];
        Boolean enabled = (Boolean)constructorObjects[i++];
        String fullName = (String)constructorObjects[i++];
        String email = (String)constructorObjects[i++];
        return new ParsedUser(username, roles, metadata, enabled, fullName, email);
    });

    GetUsersResponse(Map<String, User> users, Map<String, User> enabledUsers) {
        this.users = Map.copyOf(users);
        this.enabledUsers = Map.copyOf(enabledUsers);
    }

    public List<User> getUsers() {
        return List.copyOf(this.users.values());
    }

    public List<User> getEnabledUsers() {
        return List.copyOf(this.enabledUsers.values());
    }

    public static GetUsersResponse fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        ArrayList<User> users = new ArrayList<User>();
        ArrayList<User> enabledUsers = new ArrayList<User>();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)token, (XContentParser)parser);
            ParsedUser parsedUser = (ParsedUser)USER_PARSER.parse(parser, (Object)parser.currentName());
            users.add(parsedUser.user);
            if (!parsedUser.enabled) continue;
            enabledUsers.add(parsedUser.user);
        }
        return new GetUsersResponse(GetUsersResponse.toMap(users), GetUsersResponse.toMap(enabledUsers));
    }

    static Map<String, User> toMap(Collection<User> users) {
        return users.stream().collect(Collectors.toUnmodifiableMap(User::getUsername, Function.identity()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetUsersResponse)) {
            return false;
        }
        GetUsersResponse that = (GetUsersResponse)o;
        return Objects.equals(this.users, that.users);
    }

    public int hashCode() {
        return Objects.hash(this.users);
    }

    static {
        USER_PARSER.declareString(ConstructingObjectParser.constructorArg(), USERNAME);
        USER_PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), ROLES);
        USER_PARSER.declareObject(ConstructingObjectParser.constructorArg(), (parser, c) -> parser.map(), METADATA);
        USER_PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), ENABLED);
        USER_PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), FULL_NAME);
        USER_PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), EMAIL);
    }

    protected static final class ParsedUser {
        protected User user;
        protected boolean enabled;

        public ParsedUser(String username, List<String> roles, Map<String, Object> metadata, Boolean enabled, @Nullable String fullName, @Nullable String email) {
            String checkedUsername = Objects.requireNonNull(username, "`username` is required, cannot be null");
            List<String> checkedRoles = List.copyOf((Collection)Objects.requireNonNull(roles, "`roles` is required, cannot be null. Pass an empty list instead."));
            Map<String, Object> checkedMetadata = Collections.unmodifiableMap(Objects.requireNonNull(metadata, "`metadata` is required, cannot be null. Pass an empty map instead."));
            this.user = new User(checkedUsername, checkedRoles, checkedMetadata, fullName, email);
            this.enabled = enabled;
        }
    }
}

