/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.security;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.client.security.user.privileges.ApplicationResourcePrivileges;
import org.elasticsearch.client.security.user.privileges.GlobalPrivileges;
import org.elasticsearch.client.security.user.privileges.UserIndicesPrivileges;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.XContentParser;

public class GetUserPrivilegesResponse {
    private static final ConstructingObjectParser<GetUserPrivilegesResponse, Void> PARSER = new ConstructingObjectParser("get_user_privileges_response", true, GetUserPrivilegesResponse::buildResponseFromParserArgs);
    private Set<String> clusterPrivileges;
    private Set<GlobalPrivileges> globalPrivileges;
    private Set<UserIndicesPrivileges> indicesPrivileges;
    private Set<ApplicationResourcePrivileges> applicationPrivileges;
    private Set<String> runAsPrivilege;

    private static GetUserPrivilegesResponse buildResponseFromParserArgs(Object[] args) {
        return new GetUserPrivilegesResponse((Collection)args[0], (Collection)args[1], (Collection)args[2], (Collection)args[3], (Collection)args[4]);
    }

    public static GetUserPrivilegesResponse fromXContent(XContentParser parser) throws IOException {
        return (GetUserPrivilegesResponse)PARSER.parse(parser, null);
    }

    public GetUserPrivilegesResponse(Collection<String> clusterPrivileges, Collection<GlobalPrivileges> globalPrivileges, Collection<UserIndicesPrivileges> indicesPrivileges, Collection<ApplicationResourcePrivileges> applicationPrivileges, Collection<String> runAsPrivilege) {
        this.clusterPrivileges = Collections.unmodifiableSet(new LinkedHashSet<String>(clusterPrivileges));
        this.globalPrivileges = Collections.unmodifiableSet(new LinkedHashSet<GlobalPrivileges>(globalPrivileges));
        this.indicesPrivileges = Collections.unmodifiableSet(new LinkedHashSet<UserIndicesPrivileges>(indicesPrivileges));
        this.applicationPrivileges = Collections.unmodifiableSet(new LinkedHashSet<ApplicationResourcePrivileges>(applicationPrivileges));
        this.runAsPrivilege = Collections.unmodifiableSet(new LinkedHashSet<String>(runAsPrivilege));
    }

    public Set<String> getClusterPrivileges() {
        return this.clusterPrivileges;
    }

    public Set<GlobalPrivileges> getGlobalPrivileges() {
        return this.globalPrivileges;
    }

    public Set<UserIndicesPrivileges> getIndicesPrivileges() {
        return this.indicesPrivileges;
    }

    public Set<ApplicationResourcePrivileges> getApplicationPrivileges() {
        return this.applicationPrivileges;
    }

    public Set<String> getRunAsPrivilege() {
        return this.runAsPrivilege;
    }

    public String toString() {
        return "GetUserPrivilegesResponse{clusterPrivileges=" + this.clusterPrivileges + ", globalPrivileges=" + this.globalPrivileges + ", indicesPrivileges=" + this.indicesPrivileges + ", applicationPrivileges=" + this.applicationPrivileges + ", runAsPrivilege=" + this.runAsPrivilege + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetUserPrivilegesResponse that = (GetUserPrivilegesResponse)o;
        return Objects.equals(this.clusterPrivileges, that.clusterPrivileges) && Objects.equals(this.globalPrivileges, that.globalPrivileges) && Objects.equals(this.indicesPrivileges, that.indicesPrivileges) && Objects.equals(this.applicationPrivileges, that.applicationPrivileges) && Objects.equals(this.runAsPrivilege, that.runAsPrivilege);
    }

    public int hashCode() {
        return Objects.hash(this.clusterPrivileges, this.globalPrivileges, this.indicesPrivileges, this.applicationPrivileges, this.runAsPrivilege);
    }

    static {
        PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), new ParseField("cluster", new String[0]));
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (parser, ignore) -> GlobalPrivileges.fromXContent(parser), new ParseField("global", new String[0]));
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (parser, ignore) -> UserIndicesPrivileges.fromXContent(parser), new ParseField("indices", new String[0]));
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (parser, ignore) -> ApplicationResourcePrivileges.fromXContent(parser), new ParseField("applications", new String[0]));
        PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), new ParseField("run_as", new String[0]));
    }
}

