/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml.inference.trainedmodel;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.client.ml.inference.trainedmodel.TrainedModelLocation;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class IndexLocation
implements TrainedModelLocation {
    public static final String INDEX = "index";
    private static final ParseField NAME = new ParseField("name", new String[0]);
    private static final ConstructingObjectParser<IndexLocation, Void> PARSER = new ConstructingObjectParser("index", true, a -> new IndexLocation((String)a[0]));
    private final String index;

    public static IndexLocation fromXContent(XContentParser parser) throws IOException {
        return (IndexLocation)PARSER.parse(parser, null);
    }

    public IndexLocation(String index) {
        this.index = Objects.requireNonNull(index);
    }

    public String getIndex() {
        return this.index;
    }

    @Override
    public String getName() {
        return INDEX;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(NAME.getPreferredName(), this.index);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexLocation that = (IndexLocation)o;
        return Objects.equals(this.index, that.index);
    }

    public int hashCode() {
        return Objects.hash(this.index);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), NAME);
    }
}

