/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.client.Validatable;
import org.elasticsearch.client.core.PageParams;
import org.elasticsearch.client.ml.job.config.MlFilter;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class GetFiltersRequest
implements Validatable,
ToXContentObject {
    public static final ObjectParser<GetFiltersRequest, Void> PARSER = new ObjectParser("get_filters_request", GetFiltersRequest::new);
    private String filterId;
    private Integer from;
    private Integer size;

    public String getFilterId() {
        return this.filterId;
    }

    public Integer getFrom() {
        return this.from;
    }

    public Integer getSize() {
        return this.size;
    }

    public void setFilterId(String filterId) {
        this.filterId = filterId;
    }

    public void setFrom(Integer from) {
        this.from = from;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.filterId != null) {
            builder.field(MlFilter.ID.getPreferredName(), this.filterId);
        }
        if (this.from != null) {
            builder.field(PageParams.FROM.getPreferredName(), this.from);
        }
        if (this.size != null) {
            builder.field(PageParams.SIZE.getPreferredName(), this.size);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GetFiltersRequest request = (GetFiltersRequest)obj;
        return Objects.equals(this.filterId, request.filterId) && Objects.equals(this.from, request.from) && Objects.equals(this.size, request.size);
    }

    public int hashCode() {
        return Objects.hash(this.filterId, this.from, this.size);
    }

    static {
        PARSER.declareString(GetFiltersRequest::setFilterId, MlFilter.ID);
        PARSER.declareInt(GetFiltersRequest::setFrom, PageParams.FROM);
        PARSER.declareInt(GetFiltersRequest::setSize, PageParams.SIZE);
    }
}

