/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.indices;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.client.Validatable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class AnalyzeRequest
implements Validatable,
ToXContentObject {
    private String index;
    private String[] text;
    private String analyzer;
    private NameOrDefinition tokenizer;
    private final List<NameOrDefinition> tokenFilters = new ArrayList<NameOrDefinition>();
    private final List<NameOrDefinition> charFilters = new ArrayList<NameOrDefinition>();
    private String field;
    private boolean explain = false;
    private String[] attributes = Strings.EMPTY_ARRAY;
    private String normalizer;

    public static AnalyzeRequest withGlobalAnalyzer(String analyzer, String ... text) {
        return new AnalyzeRequest(null, analyzer, null, null, text);
    }

    public static CustomAnalyzerBuilder buildCustomAnalyzer(String tokenizer) {
        return new CustomAnalyzerBuilder(null, new NameOrDefinition(tokenizer));
    }

    public static CustomAnalyzerBuilder buildCustomAnalyzer(Map<String, Object> tokenizerSettings) {
        return new CustomAnalyzerBuilder(null, new NameOrDefinition(tokenizerSettings));
    }

    public static CustomAnalyzerBuilder buildCustomAnalyzer(String index, String tokenizer) {
        return new CustomAnalyzerBuilder(index, new NameOrDefinition(tokenizer));
    }

    public static CustomAnalyzerBuilder buildCustomAnalyzer(String index, Map<String, Object> tokenizerSettings) {
        return new CustomAnalyzerBuilder(index, new NameOrDefinition(tokenizerSettings));
    }

    public static AnalyzeRequest withIndexAnalyzer(String index, String analyzer, String ... text) {
        return new AnalyzeRequest(index, analyzer, null, null, text);
    }

    public static AnalyzeRequest withField(String index, String field, String ... text) {
        return new AnalyzeRequest(index, null, null, field, text);
    }

    public static AnalyzeRequest withNormalizer(String index, String normalizer, String ... text) {
        return new AnalyzeRequest(index, null, normalizer, null, text);
    }

    public static CustomAnalyzerBuilder buildCustomNormalizer() {
        return new CustomAnalyzerBuilder(null, null);
    }

    public static CustomAnalyzerBuilder buildCustomNormalizer(String index) {
        return new CustomAnalyzerBuilder(index, null);
    }

    private AnalyzeRequest(String index, String analyzer, String normalizer, String field, String ... text) {
        this.index = index;
        this.analyzer = analyzer;
        this.normalizer = normalizer;
        this.field = field;
        this.text = text;
    }

    private AnalyzeRequest(String index, NameOrDefinition tokenizer, List<NameOrDefinition> charFilters, List<NameOrDefinition> tokenFilters, String ... text) {
        this.index = index;
        this.analyzer = null;
        this.normalizer = null;
        this.field = null;
        this.tokenizer = tokenizer;
        this.charFilters.addAll(charFilters);
        this.tokenFilters.addAll(tokenFilters);
        this.text = text;
    }

    public String index() {
        return this.index;
    }

    public String[] text() {
        return this.text;
    }

    public String analyzer() {
        return this.analyzer;
    }

    public String normalizer() {
        return this.normalizer;
    }

    public NameOrDefinition tokenizer() {
        return this.tokenizer;
    }

    public List<NameOrDefinition> tokenFilters() {
        return this.tokenFilters;
    }

    public List<NameOrDefinition> charFilters() {
        return this.charFilters;
    }

    public String field() {
        return this.field;
    }

    public AnalyzeRequest explain(boolean explain) {
        this.explain = explain;
        return this;
    }

    public boolean explain() {
        return this.explain;
    }

    public AnalyzeRequest attributes(String ... attributes) {
        if (attributes == null) {
            throw new IllegalArgumentException("attributes must not be null");
        }
        this.attributes = attributes;
        return this;
    }

    public String[] attributes() {
        return this.attributes;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("text", (Object)this.text);
        if (!Strings.isNullOrEmpty((String)this.analyzer)) {
            builder.field("analyzer", this.analyzer);
        }
        if (this.tokenizer != null) {
            builder.field("tokenizer", (ToXContent)this.tokenizer);
        }
        if (this.tokenFilters.size() > 0) {
            builder.field("filter", this.tokenFilters);
        }
        if (this.charFilters.size() > 0) {
            builder.field("char_filter", this.charFilters);
        }
        if (!Strings.isNullOrEmpty((String)this.field)) {
            builder.field("field", this.field);
        }
        if (this.explain) {
            builder.field("explain", true);
        }
        if (this.attributes.length > 0) {
            builder.field("attributes", (Object)this.attributes);
        }
        if (!Strings.isNullOrEmpty((String)this.normalizer)) {
            builder.field("normalizer", this.normalizer);
        }
        return builder.endObject();
    }

    public static class CustomAnalyzerBuilder {
        final NameOrDefinition tokenizer;
        final String index;
        List<NameOrDefinition> charFilters = new ArrayList<NameOrDefinition>();
        List<NameOrDefinition> tokenFilters = new ArrayList<NameOrDefinition>();

        CustomAnalyzerBuilder(String index, NameOrDefinition tokenizer) {
            this.tokenizer = tokenizer;
            this.index = index;
        }

        public CustomAnalyzerBuilder addCharFilter(String name) {
            this.charFilters.add(new NameOrDefinition(name));
            return this;
        }

        public CustomAnalyzerBuilder addCharFilter(Map<String, Object> settings) {
            this.charFilters.add(new NameOrDefinition(settings));
            return this;
        }

        public CustomAnalyzerBuilder addTokenFilter(String name) {
            this.tokenFilters.add(new NameOrDefinition(name));
            return this;
        }

        public CustomAnalyzerBuilder addTokenFilter(Map<String, Object> settings) {
            this.tokenFilters.add(new NameOrDefinition(settings));
            return this;
        }

        public AnalyzeRequest build(String ... text) {
            return new AnalyzeRequest(this.index, this.tokenizer, this.charFilters, this.tokenFilters, text);
        }
    }

    static class NameOrDefinition
    implements ToXContentFragment {
        public final String name;
        public final Settings definition;

        NameOrDefinition(String name) {
            this.name = Objects.requireNonNull(name);
            this.definition = null;
        }

        NameOrDefinition(Settings settings) {
            this.name = null;
            this.definition = Objects.requireNonNull(settings);
        }

        NameOrDefinition(Map<String, ?> definition) {
            this.name = null;
            Objects.requireNonNull(definition);
            this.definition = Settings.builder().loadFromMap(definition).build();
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            if (this.definition == null) {
                return builder.value(this.name);
            }
            builder.startObject();
            this.definition.toXContent(builder, params);
            builder.endObject();
            return builder;
        }
    }
}

