/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.security.support;

import java.util.Objects;

public class ServiceTokenInfo {
    private final String name;
    private final String source;

    public ServiceTokenInfo(String name, String source) {
        this.name = Objects.requireNonNull(name, "token name is required");
        this.source = Objects.requireNonNull(source, "token source is required");
    }

    public String getName() {
        return this.name;
    }

    public String getSource() {
        return this.source;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceTokenInfo that = (ServiceTokenInfo)o;
        return this.name.equals(that.name) && this.source.equals(that.source);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.source);
    }

    public String toString() {
        return "ServiceTokenInfo{name='" + this.name + '\'' + ", source='" + this.source + '\'' + '}';
    }
}

