/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client;

import java.io.IOException;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RequestConverters;
import org.elasticsearch.client.searchable_snapshots.MountSnapshotRequest;
import org.elasticsearch.common.xcontent.ToXContent;

final class SearchableSnapshotsRequestConverters {
    SearchableSnapshotsRequestConverters() {
    }

    static Request mountSnapshot(MountSnapshotRequest mountSnapshotRequest) throws IOException {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_snapshot").addPathPart(mountSnapshotRequest.getRepository()).addPathPart(mountSnapshotRequest.getSnapshot()).addPathPartAsIs("_mount").build();
        Request request = new Request("POST", endpoint);
        RequestConverters.Params parameters = new RequestConverters.Params();
        if (mountSnapshotRequest.getMasterTimeout() != null) {
            parameters.withMasterTimeout(mountSnapshotRequest.getMasterTimeout());
        }
        if (mountSnapshotRequest.getWaitForCompletion() != null) {
            parameters.withWaitForCompletion(mountSnapshotRequest.getWaitForCompletion());
        }
        if (mountSnapshotRequest.getStorage() != null) {
            parameters.putParam("storage", mountSnapshotRequest.getStorage().storageName());
        }
        request.addParameters(parameters.asMap());
        request.setEntity(RequestConverters.createEntity((ToXContent)mountSnapshotRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        return request;
    }
}

