/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client;

import java.io.IOException;
import java.util.Collections;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.node.tasks.cancel.CancelTasksRequest;
import org.elasticsearch.action.admin.cluster.node.tasks.cancel.CancelTasksResponse;
import org.elasticsearch.action.admin.cluster.node.tasks.list.ListTasksRequest;
import org.elasticsearch.action.admin.cluster.node.tasks.list.ListTasksResponse;
import org.elasticsearch.client.RequestConverters;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;

public final class TasksClient {
    private final RestHighLevelClient restHighLevelClient;

    TasksClient(RestHighLevelClient restHighLevelClient) {
        this.restHighLevelClient = restHighLevelClient;
    }

    public ListTasksResponse list(ListTasksRequest request, RequestOptions options) throws IOException {
        return (ListTasksResponse)this.restHighLevelClient.performRequestAndParseEntity(request, RequestConverters::listTasks, options, ListTasksResponse::fromXContent, Collections.emptySet());
    }

    public void listAsync(ListTasksRequest request, RequestOptions options, ActionListener<ListTasksResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, RequestConverters::listTasks, options, ListTasksResponse::fromXContent, listener, Collections.emptySet());
    }

    public CancelTasksResponse cancel(CancelTasksRequest cancelTasksRequest, RequestOptions options) throws IOException {
        return (CancelTasksResponse)this.restHighLevelClient.performRequestAndParseEntity(cancelTasksRequest, RequestConverters::cancelTasks, options, CancelTasksResponse::fromXContent, Collections.emptySet());
    }

    public void cancelAsync(CancelTasksRequest cancelTasksRequest, RequestOptions options, ActionListener<CancelTasksResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(cancelTasksRequest, RequestConverters::cancelTasks, options, CancelTasksResponse::fromXContent, listener, Collections.emptySet());
    }
}

