/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.jcache;

import javax.cache.management.CacheStatisticsMXBean;
import org.ehcache.jcache.JCache;
import org.ehcache.jcache.JCacheMXBean;

public class JCacheStatMXBean
extends JCacheMXBean
implements CacheStatisticsMXBean {
    public JCacheStatMXBean(JCache jCache) {
        super(jCache, "Statistics");
    }

    public void clear() {
        this.jCache.clear();
    }

    public long getCacheHits() {
        return this.getEhcache().getStatistics().cacheHitCount();
    }

    public float getCacheHitPercentage() {
        double v = this.getEhcache().getStatistics().cacheHitRatio();
        if (Double.isNaN(v)) {
            return this.getEhcache().getStatistics().cacheHitCount() == 0L ? 0.0f : 100.0f;
        }
        return (float)v * 100.0f;
    }

    public long getCacheMisses() {
        return this.getEhcache().getStatistics().cacheMissCount();
    }

    public float getCacheMissPercentage() {
        double v = this.getEhcache().getStatistics().cacheHitRatio();
        if (Double.isNaN(v)) {
            return 0.0f;
        }
        return (float)(1.0 - v) * 100.0f;
    }

    public long getCacheGets() {
        return (Long)this.getEhcache().getStatistics().cacheGetOperation().count().value();
    }

    public long getCachePuts() {
        return this.getEhcache().getStatistics().cachePutCount();
    }

    public long getCacheRemovals() {
        return this.getEhcache().getStatistics().cacheRemoveCount();
    }

    public long getCacheEvictions() {
        return this.getEhcache().getStatistics().cacheEvictedCount();
    }

    public float getAverageGetTime() {
        float v = ((Double)this.getEhcache().getStatistics().cacheGetOperation().latency().average().value()).floatValue();
        return Float.isNaN(v) ? 0.0f : v;
    }

    public float getAveragePutTime() {
        float v = ((Double)this.getEhcache().getStatistics().cachePutOperation().latency().average().value()).floatValue();
        return Float.isNaN(v) ? 0.0f : v;
    }

    public float getAverageRemoveTime() {
        float v = ((Double)this.getEhcache().getStatistics().cacheRemoveOperation().latency().average().value()).floatValue();
        return Float.isNaN(v) ? 0.0f : v;
    }
}

