/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.sequencing;

import org.eclipse.persistence.internal.jpa.metadata.MetadataLogger;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.tables.TableMetadata;
import org.eclipse.persistence.sequencing.TableSequence;

public class TableGeneratorMetadata
extends TableMetadata {
    private Integer m_allocationSize;
    private Integer m_initialValue;
    private String m_generatorName;
    private String m_pkColumnValue;
    private String m_pkColumnName;
    private String m_valueColumnName;

    protected TableGeneratorMetadata() {
        super("<table-generator>");
    }

    public TableGeneratorMetadata(MetadataAnnotation tableGenerator, MetadataAccessor accessor) {
        super(tableGenerator, accessor);
        this.m_allocationSize = (Integer)tableGenerator.getAttribute("allocationSize");
        this.m_initialValue = (Integer)tableGenerator.getAttribute("initialValue");
        this.m_generatorName = (String)tableGenerator.getAttributeString("name");
        this.m_pkColumnName = (String)tableGenerator.getAttributeString("pkColumnName");
        this.m_pkColumnValue = (String)tableGenerator.getAttributeString("pkColumnValue");
        this.m_valueColumnName = (String)tableGenerator.getAttributeString("valueColumnName");
        this.setName((String)tableGenerator.getAttribute("table"));
    }

    public TableGeneratorMetadata(String pkColumnValue) {
        this.m_pkColumnValue = pkColumnValue;
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof TableGeneratorMetadata) {
            TableGeneratorMetadata generator = (TableGeneratorMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_allocationSize, generator.getAllocationSize())) {
                return false;
            }
            if (!this.valuesMatch(this.m_initialValue, generator.getInitialValue())) {
                return false;
            }
            if (!this.valuesMatch(this.m_generatorName, generator.getGeneratorName())) {
                return false;
            }
            if (!this.valuesMatch(this.m_pkColumnValue, generator.getPkColumnValue())) {
                return false;
            }
            if (!this.valuesMatch(this.m_pkColumnName, generator.getPkColumnName())) {
                return false;
            }
            return this.valuesMatch(this.m_valueColumnName, generator.getValueColumnName());
        }
        return false;
    }

    public Integer getAllocationSize() {
        return this.m_allocationSize;
    }

    @Override
    public String getCatalogContext() {
        return "metadata_default_table_generator_catalog";
    }

    public String getGeneratorName() {
        return this.m_generatorName;
    }

    @Override
    public String getIdentifier() {
        return this.m_generatorName;
    }

    public Integer getInitialValue() {
        return this.m_initialValue;
    }

    @Override
    public String getNameContext() {
        return "metadata_default_table_generator_name";
    }

    public String getPkColumnName() {
        return this.m_pkColumnName;
    }

    public String getPkColumnValue() {
        return this.m_pkColumnValue;
    }

    @Override
    public String getSchemaContext() {
        return "metadata_default_table_generator_schema";
    }

    public String getValueColumnName() {
        return this.m_valueColumnName;
    }

    public TableSequence process(MetadataLogger logger) {
        TableSequence sequence = new TableSequence();
        if (this.m_pkColumnValue == null || this.m_pkColumnValue.equals("")) {
            logger.logConfigMessage("metadata_default_table_generator_pk_column_value", this.m_generatorName, (Object)this.getAccessibleObject(), this.getLocation());
            sequence.setName(this.m_generatorName);
        } else {
            sequence.setName(this.m_pkColumnValue);
        }
        sequence.setPreallocationSize(this.m_allocationSize == null ? Integer.valueOf(50) : this.m_allocationSize);
        sequence.setInitialValue(this.m_initialValue == null ? Integer.valueOf(0) : this.m_initialValue);
        sequence.setTable(this.getDatabaseTable());
        if (this.m_pkColumnName != null && !this.m_pkColumnName.equals("")) {
            sequence.setNameFieldName(this.m_pkColumnName);
        }
        if (this.m_valueColumnName != null && !this.m_valueColumnName.equals("")) {
            sequence.setCounterFieldName(this.m_valueColumnName);
        }
        return sequence;
    }

    public void setAllocationSize(Integer allocationSize) {
        this.m_allocationSize = allocationSize;
    }

    public void setGeneratorName(String generatorName) {
        this.m_generatorName = generatorName;
    }

    public void setInitialValue(Integer initialValue) {
        this.m_initialValue = initialValue;
    }

    public void setPkColumnName(String pkColumnName) {
        this.m_pkColumnName = pkColumnName;
    }

    public void setPkColumnValue(String pkColumnValue) {
        this.m_pkColumnValue = pkColumnValue;
    }

    public void setValueColumnName(String valueColumnName) {
        this.m_valueColumnName = valueColumnName;
    }

    public String toString() {
        return "TableGenerator[" + this.m_generatorName + "]";
    }
}

