/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.expressions.ExpressionOperator;
import org.eclipse.persistence.internal.expressions.CompoundExpression;
import org.eclipse.persistence.internal.expressions.ConstantExpression;
import org.eclipse.persistence.internal.expressions.ExpressionJavaPrinter;
import org.eclipse.persistence.internal.expressions.ExpressionNormalizer;
import org.eclipse.persistence.internal.expressions.ExpressionSQLPrinter;
import org.eclipse.persistence.internal.expressions.FieldExpression;
import org.eclipse.persistence.internal.expressions.FunctionExpression;
import org.eclipse.persistence.internal.expressions.ObjectExpression;
import org.eclipse.persistence.internal.expressions.ParameterExpression;
import org.eclipse.persistence.internal.expressions.QueryKeyExpression;
import org.eclipse.persistence.internal.expressions.SubSelectExpression;
import org.eclipse.persistence.internal.expressions.TableAliasLookup;
import org.eclipse.persistence.internal.expressions.TableExpression;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.queries.ReportQuery;

public class RelationExpression
extends CompoundExpression {
    protected Boolean isObjectComparisonExpression;

    protected boolean allChildrenAreFields() {
        return this.getFirstChild().getFields().size() == 1 && this.getSecondChild().getFields().size() == 1;
    }

    protected void convertNodeToUseOuterJoin() {
        if (this.getOperator().getSelector() == 4 && this.allChildrenAreFields()) {
            this.setOperator(this.getOperator(6));
        }
    }

    public String descriptionOfNodeType() {
        return "Relation";
    }

    public boolean doesConform(Object object, AbstractSession session, AbstractRecord translationRow, int valueHolderPolicy, boolean isObjectUnregistered) {
        Object rightValue = this.getSecondChild().valueFromObject(object, session, translationRow, valueHolderPolicy, isObjectUnregistered);
        Object leftValue = this.getFirstChild().valueFromObject(object, session, translationRow, valueHolderPolicy, isObjectUnregistered);
        if (rightValue instanceof Collection) {
            if (this.getOperator().getSelector() == 13 || this.getOperator().getSelector() == 14) {
                if (this.isObjectComparison()) {
                    throw QueryException.cannotConformExpression();
                }
                if (leftValue instanceof Vector) {
                    return this.doesAnyOfLeftValuesConform((Vector)leftValue, rightValue, session);
                }
                return this.getOperator().doesRelationConform(leftValue, rightValue);
            }
            Enumeration rightEnum = ((Vector)rightValue).elements();
            while (rightEnum.hasMoreElements()) {
                Object tempRight = rightEnum.nextElement();
                if (leftValue instanceof Vector && this.doesAnyOfLeftValuesConform((Vector)leftValue, tempRight, session)) {
                    return true;
                }
                if (!this.doValuesConform(leftValue, tempRight, session)) continue;
                return true;
            }
            return false;
        }
        if (leftValue instanceof Vector) {
            return this.doesAnyOfLeftValuesConform((Vector)leftValue, rightValue, session);
        }
        return this.doValuesConform(leftValue, rightValue, session);
    }

    protected boolean doesAnyOfLeftValuesConform(Vector leftValues, Object rightValue, AbstractSession session) {
        for (int index = 0; index < leftValues.size(); ++index) {
            Object leftValue = leftValues.get(index);
            if (!this.doValuesConform(leftValue, rightValue, session)) continue;
            return true;
        }
        return false;
    }

    protected boolean doValuesConform(Object leftValue, Object rightValue, AbstractSession session) {
        if (this.isObjectComparison()) {
            return this.doesObjectConform(leftValue, rightValue, session);
        }
        return this.getOperator().doesRelationConform(leftValue, rightValue);
    }

    public boolean doesObjectConform(Object leftValue, Object rightValue, AbstractSession session) {
        if (leftValue == null && rightValue == null) {
            return this.performSelector(true);
        }
        if (leftValue == null || rightValue == null) {
            return this.performSelector(false);
        }
        Class<?> javaClass = leftValue.getClass();
        if (javaClass != rightValue.getClass()) {
            return this.performSelector(false);
        }
        ClassDescriptor descriptor = session.getDescriptor(javaClass);
        if (descriptor.isAggregateDescriptor()) {
            throw QueryException.cannotConformExpression();
        }
        Vector leftPrimaryKey = descriptor.getObjectBuilder().extractPrimaryKeyFromObject(leftValue, session);
        Vector rightPrimaryKey = descriptor.getObjectBuilder().extractPrimaryKeyFromObject(rightValue, session);
        CacheKey rightCacheKey = new CacheKey(rightPrimaryKey);
        CacheKey leftCacheKey = new CacheKey(leftPrimaryKey);
        return this.performSelector(rightCacheKey.equals(leftCacheKey));
    }

    public boolean extractPrimaryKeyValues(boolean requireExactMatch, ClassDescriptor descriptor, AbstractRecord primaryKeyRow, AbstractRecord translationRow) {
        if (requireExactMatch && this.getOperator().getSelector() != 4) {
            return false;
        }
        if (!requireExactMatch && this.getOperator().getSelector() == 13) {
            return false;
        }
        DatabaseField field = null;
        Object value = null;
        if (this.getSecondChild().isConstantExpression()) {
            value = ((ConstantExpression)this.getSecondChild()).getValue();
        } else if (this.getSecondChild().isParameterExpression() && translationRow != null) {
            value = translationRow.get(((ParameterExpression)this.getSecondChild()).getField());
        } else if (this.getFirstChild().isConstantExpression()) {
            value = ((ConstantExpression)this.getFirstChild()).getValue();
        } else if (this.getFirstChild().isParameterExpression() && translationRow != null) {
            value = translationRow.get(((ParameterExpression)this.getFirstChild()).getField());
        }
        if (value == null) {
            return false;
        }
        if (this.getFirstChild().isFieldExpression()) {
            FieldExpression child = (FieldExpression)this.getFirstChild();
            if (!child.getBaseExpression().isExpressionBuilder()) {
                return false;
            }
            field = child.getField();
        } else if (this.getFirstChild().isQueryKeyExpression()) {
            QueryKeyExpression child = (QueryKeyExpression)this.getFirstChild();
            if (!child.getBaseExpression().isExpressionBuilder()) {
                return false;
            }
            DatabaseMapping mapping = descriptor.getObjectBuilder().getMappingForAttributeName(child.getName());
            if (mapping != null) {
                if (!mapping.isPrimaryKeyMapping()) {
                    return false;
                }
                if (mapping.isObjectReferenceMapping() || mapping.isAggregateObjectMapping()) {
                    mapping.writeFromAttributeIntoRow(value, primaryKeyRow, this.getSession());
                    return true;
                }
                if (!mapping.isDirectToFieldMapping()) {
                    return false;
                }
                field = ((AbstractDirectMapping)mapping).getField();
            } else {
                field = descriptor.getObjectBuilder().getFieldForQueryKeyName(child.getName());
            }
        } else if (this.getSecondChild().isFieldExpression()) {
            FieldExpression child = (FieldExpression)this.getSecondChild();
            if (!child.getBaseExpression().isExpressionBuilder()) {
                return false;
            }
            field = child.getField();
        } else if (this.getSecondChild().isQueryKeyExpression()) {
            QueryKeyExpression child = (QueryKeyExpression)this.getSecondChild();
            if (!child.getBaseExpression().isExpressionBuilder()) {
                return false;
            }
            DatabaseMapping mapping = descriptor.getObjectBuilder().getMappingForAttributeName(child.getName());
            if (mapping != null) {
                if (!mapping.isPrimaryKeyMapping()) {
                    return false;
                }
                if (mapping.isObjectReferenceMapping() || mapping.isAggregateObjectMapping()) {
                    mapping.writeFromAttributeIntoRow(value, primaryKeyRow, this.getSession());
                    return true;
                }
                if (!mapping.isDirectToFieldMapping()) {
                    return false;
                }
                field = ((AbstractDirectMapping)mapping).getField();
            } else {
                field = descriptor.getObjectBuilder().getFieldForQueryKeyName(child.getName());
            }
        } else {
            return false;
        }
        if (field == null || !descriptor.getPrimaryKeyFields().contains(field)) {
            return false;
        }
        primaryKeyRow.put(field, value);
        return true;
    }

    public boolean isEqualNull(ExpressionSQLPrinter printer) {
        if (this.isObjectComparison()) {
            return false;
        }
        if (this.getOperator().getSelector() != 4) {
            return false;
        }
        if (this.getSecondChild().isConstantExpression() && ((ConstantExpression)this.getSecondChild()).getValue() == null) {
            return true;
        }
        return this.getSecondChild().isParameterExpression() && printer.getTranslationRow() != null && ((ParameterExpression)this.getSecondChild()).getValue(printer.getTranslationRow(), printer.getSession()) == null;
    }

    public boolean isNotEqualNull(ExpressionSQLPrinter printer) {
        if (this.isObjectComparison()) {
            return false;
        }
        if (this.getOperator().getSelector() != 5) {
            return false;
        }
        if (this.getSecondChild().isConstantExpression() && ((ConstantExpression)this.getSecondChild()).getValue() == null) {
            return true;
        }
        return this.getSecondChild().isParameterExpression() && printer.getTranslationRow() != null && ((ParameterExpression)this.getSecondChild()).getValue(printer.getTranslationRow(), printer.getSession()) == null;
    }

    protected boolean isObjectComparison() {
        if (this.isObjectComparisonExpression == null) {
            DatabaseMapping mapping;
            this.isObjectComparisonExpression = !this.firstChild.isObjectExpression() || ((ObjectExpression)this.firstChild).isAttribute() ? Boolean.FALSE : ((mapping = ((ObjectExpression)this.firstChild).getMapping()) != null && mapping.isDirectCollectionMapping() ? Boolean.FALSE : Boolean.valueOf(this.secondChild.isObjectExpression() || this.secondChild.isValueExpression() || this.secondChild.isFunctionExpression() && ((FunctionExpression)this.secondChild).getOperator().isAnyOrAll()));
        }
        return this.isObjectComparisonExpression;
    }

    public boolean isRelationExpression() {
        return true;
    }

    public Expression normalize(ExpressionNormalizer normalizer) {
        FunctionExpression funcExp;
        if (!this.isObjectComparison()) {
            return super.normalize(normalizer);
        }
        this.validateNode();
        if (this.getOperator().getSelector() != 4 && this.getOperator().getSelector() != 5) {
            throw QueryException.invalidOperatorForObjectComparison(this);
        }
        if (this.getSecondChild().isFunctionExpression() && (funcExp = (FunctionExpression)this.getSecondChild()).getOperator().isAnyOrAll()) {
            Expression newExp;
            SubSelectExpression subSelectExp = (SubSelectExpression)funcExp.getChildren().elementAt(1);
            ReportQuery subQuery = subSelectExp.getSubQuery();
            subQuery.getItems().clear();
            subQuery.addItem("one", new ConstantExpression(new Integer(1), subQuery.getExpressionBuilder()));
            Expression subSelectCriteria = subQuery.getSelectionCriteria();
            ExpressionBuilder subBuilder = subQuery.getExpressionBuilder();
            ExpressionBuilder builder = this.getFirstChild().getBuilder();
            if (funcExp.getOperator().isAny()) {
                subSelectCriteria = this.getOperator().getSelector() == 4 ? subBuilder.equal(this.getFirstChild()).and(subSelectCriteria) : subBuilder.notEqual(this.getFirstChild()).and(subSelectCriteria);
                subQuery.setSelectionCriteria(subSelectCriteria);
                newExp = builder.exists(subQuery);
            } else {
                subSelectCriteria = this.getOperator().getSelector() == 4 ? subBuilder.notEqual(this.getFirstChild()).and(subSelectCriteria) : subBuilder.equal(this.getFirstChild()).and(subSelectCriteria);
                subQuery.setSelectionCriteria(subSelectCriteria);
                newExp = builder.notExists(subQuery);
            }
            return newExp.normalize(normalizer);
        }
        Expression foreignKeyJoin = null;
        ObjectExpression first = (ObjectExpression)this.getFirstChild();
        if (first.isExpressionBuilder() && this.getSecondChild().isQueryKeyExpression() && !((QueryKeyExpression)this.getSecondChild()).hasDerivedExpressions()) {
            first = (ExpressionBuilder)first.normalize(normalizer);
            Vector foreignKeyJoinPointer = new Vector(1);
            QueryKeyExpression second = (QueryKeyExpression)this.getSecondChild();
            if (second.hasBeenNormalized()) {
                second.setHasBeenNormalized(false);
            }
            second = (QueryKeyExpression)second.normalize(normalizer, foreignKeyJoinPointer);
            if (!foreignKeyJoinPointer.isEmpty()) {
                foreignKeyJoin = (Expression)foreignKeyJoinPointer.firstElement();
                if (first.getTableAliases() == null) {
                    TableAliasLookup tableAliases = new TableAliasLookup();
                    first.setTableAliases(tableAliases);
                    second.setTableAliases(tableAliases);
                } else {
                    second.setTableAliases(first.getTableAliases());
                }
            }
        } else if (!first.isExpressionBuilder() && !((QueryKeyExpression)first).shouldQueryToManyRelationship() && ((QueryKeyExpression)first).getMapping() != null) {
            if (first.getBaseExpression() != null) {
                first.setBaseExpression(first.getBaseExpression().normalize(normalizer));
            }
            if (this.getSecondChild().isConstantExpression()) {
                Object targetObject = ((ConstantExpression)this.getSecondChild()).getValue();
                foreignKeyJoin = first.getMapping().buildObjectJoinExpression((Expression)first, targetObject, this.getSession());
            } else if (this.getSecondChild().isObjectExpression() || this.getSecondChild().isParameterExpression()) {
                foreignKeyJoin = first.getMapping().buildObjectJoinExpression((Expression)first, this.getSecondChild(), this.getSession());
            } else {
                throw QueryException.invalidUseOfToManyQueryKeyInExpression(this);
            }
        }
        if (foreignKeyJoin == null) {
            first = (ObjectExpression)first.normalize(normalizer);
            if (this.getSecondChild().isConstantExpression()) {
                Expression keyExpression = first.getDescriptor().getObjectBuilder().buildPrimaryKeyExpressionFromObject(((ConstantExpression)this.getSecondChild()).getValue(), this.getSession());
                foreignKeyJoin = first.twist(keyExpression, first);
            } else if (this.getSecondChild().isObjectExpression() || this.getSecondChild().isParameterExpression()) {
                foreignKeyJoin = first.twist(first.getDescriptor().getObjectBuilder().getPrimaryKeyExpression(), this.getSecondChild());
            } else {
                throw QueryException.invalidUseOfToManyQueryKeyInExpression(this);
            }
        }
        if (this.getOperator().getSelector() == 5) {
            foreignKeyJoin = foreignKeyJoin.not();
        }
        return foreignKeyJoin.normalize(normalizer);
    }

    public boolean performSelector(boolean areValuesEqual) {
        if (this.getOperator().getSelector() == 4) {
            return areValuesEqual;
        }
        if (this.getOperator().getSelector() == 5) {
            return !areValuesEqual;
        }
        throw QueryException.cannotConformExpression();
    }

    public void printSQL(ExpressionSQLPrinter printer) {
        if (this.isEqualNull(printer)) {
            this.getFirstChild().isNull().printSQL(printer);
        } else if (this.isNotEqualNull(printer)) {
            this.getFirstChild().notNull().printSQL(printer);
        } else {
            super.printSQL(printer);
        }
    }

    public void printJava(ExpressionJavaPrinter printer) {
        ExpressionOperator realOperator = this.getPlatformOperator(printer.getPlatform());
        Expression tempFirstChild = this.getFirstChild();
        Expression tempSecondChild = this.getSecondChild();
        realOperator.printJavaDuo(tempFirstChild, tempSecondChild, printer);
    }

    public void printSQLNoParens(ExpressionSQLPrinter printer) {
        ExpressionOperator realOperator = this.getPlatformOperator(printer.getPlatform());
        realOperator.printDuo(this.getFirstChild(), this.getSecondChild(), printer);
    }

    public void validateNode() {
        if (this.getFirstChild().isTableExpression()) {
            throw QueryException.cannotCompareTablesInExpression(((TableExpression)this.getFirstChild()).getTable());
        }
        if (this.getSecondChild().isTableExpression()) {
            throw QueryException.cannotCompareTablesInExpression(((TableExpression)this.getSecondChild()).getTable());
        }
    }
}

