/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.descriptors;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;

public class CascadeLockingPolicy {
    protected Class m_parentClass;
    protected ReadObjectQuery m_query;
    protected ClassDescriptor m_descriptor;
    protected ClassDescriptor m_parentDescriptor;
    protected Map m_queryKeyFields;
    protected Vector m_mappingLookupFields;
    protected DatabaseMapping m_parentMapping;

    public CascadeLockingPolicy(ClassDescriptor parentDescriptor, ClassDescriptor descriptor) {
        this.m_descriptor = descriptor;
        this.m_parentDescriptor = parentDescriptor;
        this.m_parentClass = this.m_parentDescriptor.getJavaClass();
    }

    protected ReadObjectQuery getQuery() {
        if (this.m_query == null) {
            this.m_query = new ReadObjectQuery(this.m_parentClass);
            Expression selectionCriteria = null;
            Iterator keys = this.m_queryKeyFields.keySet().iterator();
            ExpressionBuilder builder = new ExpressionBuilder();
            while (keys.hasNext()) {
                String keyField = ((DatabaseField)keys.next()).getQualifiedName();
                if (selectionCriteria == null) {
                    selectionCriteria = builder.getField(keyField).equal(builder.getParameter(keyField));
                } else {
                    selectionCriteria.and(builder.getField(keyField).equal(builder.getParameter(keyField)));
                }
                this.m_query.addArgument(keyField);
            }
            this.m_query.setSelectionCriteria(selectionCriteria);
            this.m_query.setShouldUseWrapperPolicy(false);
        }
        return this.m_query;
    }

    protected DatabaseMapping getParentMapping() {
        if (this.m_parentMapping == null && this.m_mappingLookupFields != null && this.m_query == null) {
            Enumeration fields = this.m_mappingLookupFields.elements();
            while (fields.hasMoreElements()) {
                DatabaseMapping mapping = this.m_descriptor.getObjectBuilder().getMappingForField((DatabaseField)fields.nextElement());
                if (!mapping.isObjectReferenceMapping()) continue;
                this.m_parentMapping = mapping;
                break;
            }
        }
        return this.m_parentMapping;
    }

    protected AbstractRecord getTranslationRow(Object changedObj, UnitOfWorkImpl uow) {
        DatabaseRecord translationRow = new DatabaseRecord();
        for (DatabaseField keyField : this.m_queryKeyFields.keySet()) {
            DatabaseField valueField = (DatabaseField)this.m_queryKeyFields.get(keyField);
            Object value = this.m_descriptor.getObjectBuilder().extractValueFromObjectForField(changedObj, valueField, uow);
            translationRow.add(keyField, value);
        }
        return translationRow;
    }

    public void lockNotifyParent(Object obj, UnitOfWorkChangeSet changeSet, UnitOfWorkImpl uow) {
        Object parentObj = null;
        DatabaseMapping parentMapping = this.getParentMapping();
        if (parentMapping != null && parentMapping.isObjectReferenceMapping()) {
            parentObj = parentMapping.getRealAttributeValueFromObject(obj, uow);
        }
        if (parentObj == null) {
            parentObj = uow.executeQuery((DatabaseQuery)this.getQuery(), this.getTranslationRow(obj, uow));
        } else if (this.m_parentDescriptor.hasWrapperPolicy()) {
            this.m_parentDescriptor.getWrapperPolicy().unwrapObject(parentObj, uow);
        }
        if (parentObj != null) {
            ObjectChangeSet ocs;
            if (this.m_parentDescriptor.usesOptimisticLocking() && this.m_parentDescriptor.getOptimisticLockingPolicy().isCascaded() && !(ocs = this.m_parentDescriptor.getObjectBuilder().createObjectChangeSet(parentObj, changeSet, uow)).hasForcedChangesFromCascadeLocking()) {
                ocs.setHasForcedChangesFromCascadeLocking(true);
                changeSet.addObjectChangeSet(ocs, uow, true);
            }
            if (this.m_parentDescriptor.hasCascadeLockingPolicies()) {
                Enumeration policies = this.m_parentDescriptor.getCascadeLockingPolicies().elements();
                while (policies.hasMoreElements()) {
                    CascadeLockingPolicy policy = (CascadeLockingPolicy)policies.nextElement();
                    policy.lockNotifyParent(parentObj, changeSet, uow);
                }
            }
        }
    }

    public void setQueryKeyFields(Map queryKeyFields) {
        this.setQueryKeyFields(queryKeyFields, true);
    }

    public void setQueryKeyFields(Map queryKeyFields, boolean lookForParentMapping) {
        this.m_queryKeyFields = queryKeyFields;
        if (lookForParentMapping) {
            this.m_mappingLookupFields = NonSynchronizedVector.newInstance();
            Iterator keys = this.m_queryKeyFields.keySet().iterator();
            while (keys.hasNext()) {
                this.m_mappingLookupFields.add(this.m_queryKeyFields.get(keys.next()));
            }
        }
    }
}

