/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper.delegates;

import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Type;
import commonj.sdo.helper.HelperContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.SDOException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.sdo.SDOConstants;
import org.eclipse.persistence.sdo.SDODataObject;
import org.eclipse.persistence.sdo.SDOProperty;
import org.eclipse.persistence.sdo.SDOType;
import org.eclipse.persistence.sdo.helper.SDOTypeHelper;
import org.eclipse.persistence.sdo.helper.SDOXMLHelper;
import org.eclipse.persistence.sdo.helper.SDOXSDHelper;

public class SDOTypeHelperDelegate
implements SDOTypeHelper {
    private Map typesHashMap;
    private static final Map commonjHashMap = new HashMap();
    private static final Map commonjJavaHashMap = new HashMap();
    private static final Map sdoTypeForSimpleJavaType = new HashMap();
    private static final Map sdoToXSDTypes = new HashMap();
    private static final Map xsdToSDOType = new HashMap();
    private Map openContentProperties;
    private HelperContext aHelperContext;
    private NamespaceResolver namespaceResolver;

    public SDOTypeHelperDelegate(HelperContext aContext) {
        this.aHelperContext = aContext;
        this.initTypesHashMap();
        this.initOpenProps();
    }

    private static void initCommonjHashMap() {
        commonjHashMap.put("Boolean", SDOConstants.SDO_BOOLEAN);
        commonjHashMap.put("Byte", SDOConstants.SDO_BYTE);
        commonjHashMap.put("Bytes", SDOConstants.SDO_BYTES);
        commonjHashMap.put("Character", SDOConstants.SDO_CHARACTER);
        commonjHashMap.put("DataObject", SDOConstants.SDO_DATAOBJECT);
        commonjHashMap.put("Date", SDOConstants.SDO_DATE);
        commonjHashMap.put("DateTime", SDOConstants.SDO_DATETIME);
        commonjHashMap.put("Day", SDOConstants.SDO_DAY);
        commonjHashMap.put("Decimal", SDOConstants.SDO_DECIMAL);
        commonjHashMap.put("Double", SDOConstants.SDO_DOUBLE);
        commonjHashMap.put("Duration", SDOConstants.SDO_DURATION);
        commonjHashMap.put("Float", SDOConstants.SDO_FLOAT);
        commonjHashMap.put("Int", SDOConstants.SDO_INT);
        commonjHashMap.put("Integer", SDOConstants.SDO_INTEGER);
        commonjHashMap.put("Long", SDOConstants.SDO_LONG);
        commonjHashMap.put("Month", SDOConstants.SDO_MONTH);
        commonjHashMap.put("MonthDay", SDOConstants.SDO_MONTHDAY);
        commonjHashMap.put("Object", SDOConstants.SDO_OBJECT);
        commonjHashMap.put("Short", SDOConstants.SDO_SHORT);
        commonjHashMap.put("String", SDOConstants.SDO_STRING);
        commonjHashMap.put("Strings", SDOConstants.SDO_STRINGS);
        commonjHashMap.put("Time", SDOConstants.SDO_TIME);
        commonjHashMap.put("Year", SDOConstants.SDO_YEAR);
        commonjHashMap.put("YearMonth", SDOConstants.SDO_YEARMONTH);
        commonjHashMap.put("YearMonthDay", SDOConstants.SDO_YEARMONTHDAY);
        commonjHashMap.put("URI", SDOConstants.SDO_URI);
        commonjHashMap.put("ChangeSummaryType", SDOConstants.SDO_CHANGESUMMARY);
        commonjHashMap.put("Type", SDOConstants.SDO_TYPE);
        commonjHashMap.put("Property", SDOConstants.SDO_PROPERTY);
    }

    private static void initCommonjJavaHashMap() {
        commonjJavaHashMap.put("BooleanObject", SDOConstants.SDO_BOOLEANOBJECT);
        commonjJavaHashMap.put("ByteObject", SDOConstants.SDO_BYTEOBJECT);
        commonjJavaHashMap.put("CharacterObject", SDOConstants.SDO_CHARACTEROBJECT);
        commonjJavaHashMap.put("DoubleObject", SDOConstants.SDO_DOUBLEOBJECT);
        commonjJavaHashMap.put("FloatObject", SDOConstants.SDO_FLOATOBJECT);
        commonjJavaHashMap.put("IntObject", SDOConstants.SDO_INTOBJECT);
        commonjJavaHashMap.put("LongObject", SDOConstants.SDO_LONGOBJECT);
        commonjJavaHashMap.put("ShortObject", SDOConstants.SDO_SHORTOBJECT);
    }

    private void initTypesHashMap() {
        this.typesHashMap = new HashMap();
        QName qname = new QName("org.eclipse.persistence.sdo", "LoadOptions");
        this.typesHashMap.put(qname, SDOConstants.SDO_XMLHELPER_LOAD_OPTIONS);
        QName customTypeQname = new QName(SDOConstants.SDO_OPEN_SEQUENCED.getURI(), SDOConstants.SDO_OPEN_SEQUENCED.getName());
        this.typesHashMap.put(customTypeQname, SDOConstants.SDO_OPEN_SEQUENCED);
    }

    private static void initSdoToXSDType() {
        sdoToXSDTypes.put(SDOConstants.SDO_BOOLEAN, XMLConstants.BOOLEAN_QNAME);
        sdoToXSDTypes.put(SDOConstants.SDO_BYTE, XMLConstants.BYTE_QNAME);
        sdoToXSDTypes.put(SDOConstants.SDO_BYTES, XMLConstants.HEX_BINARY_QNAME);
        sdoToXSDTypes.put(SDOConstants.SDO_CHARACTER, XMLConstants.STRING_QNAME);
        sdoToXSDTypes.put(SDOConstants.SDO_DATE, XMLConstants.DATE_TIME_QNAME);
        sdoToXSDTypes.put(SDOConstants.SDO_DATETIME, XMLConstants.DATE_TIME_QNAME);
        sdoToXSDTypes.put(SDOConstants.SDO_DATAOBJECT, SDOConstants.ANY_TYPE_QNAME);
        sdoToXSDTypes.put(SDOConstants.SDO_DAY, SDOConstants.GDAY_QNAME);
        sdoToXSDTypes.put(SDOConstants.SDO_DECIMAL, XMLConstants.DECIMAL_QNAME);
        sdoToXSDTypes.put(SDOConstants.SDO_DOUBLE, XMLConstants.DOUBLE_QNAME);
        sdoToXSDTypes.put(SDOConstants.SDO_DURATION, SDOConstants.DURATION_QNAME);
        sdoToXSDTypes.put(SDOConstants.SDO_FLOAT, XMLConstants.FLOAT_QNAME);
        sdoToXSDTypes.put(SDOConstants.SDO_INT, XMLConstants.INT_QNAME);
        sdoToXSDTypes.put(SDOConstants.SDO_INTEGER, XMLConstants.INTEGER_QNAME);
        sdoToXSDTypes.put(SDOConstants.SDO_LONG, XMLConstants.LONG_QNAME);
        sdoToXSDTypes.put(SDOConstants.SDO_MONTH, SDOConstants.GMONTH_QNAME);
        sdoToXSDTypes.put(SDOConstants.SDO_MONTHDAY, SDOConstants.GMONTHDAY_QNAME);
        sdoToXSDTypes.put(SDOConstants.SDO_OBJECT, XMLConstants.ANY_SIMPLE_TYPE_QNAME);
        sdoToXSDTypes.put(SDOConstants.SDO_SHORT, XMLConstants.SHORT_QNAME);
        sdoToXSDTypes.put(SDOConstants.SDO_STRING, XMLConstants.STRING_QNAME);
        sdoToXSDTypes.put(SDOConstants.SDO_STRINGS, XMLConstants.STRING_QNAME);
        sdoToXSDTypes.put(SDOConstants.SDO_TIME, XMLConstants.TIME_QNAME);
        sdoToXSDTypes.put(SDOConstants.SDO_YEAR, SDOConstants.GYEAR_QNAME);
        sdoToXSDTypes.put(SDOConstants.SDO_YEARMONTH, SDOConstants.GYEARMONTH_QNAME);
        sdoToXSDTypes.put(SDOConstants.SDO_YEARMONTHDAY, XMLConstants.DATE_QNAME);
        sdoToXSDTypes.put(SDOConstants.SDO_URI, SDOConstants.ANY_URI_QNAME);
        sdoToXSDTypes.put(SDOConstants.SDO_BOOLEANOBJECT, XMLConstants.BOOLEAN_QNAME);
        sdoToXSDTypes.put(SDOConstants.SDO_BYTEOBJECT, XMLConstants.BYTE_QNAME);
        sdoToXSDTypes.put(SDOConstants.SDO_CHARACTEROBJECT, XMLConstants.STRING_QNAME);
        sdoToXSDTypes.put(SDOConstants.SDO_DOUBLEOBJECT, XMLConstants.DOUBLE_QNAME);
        sdoToXSDTypes.put(SDOConstants.SDO_FLOATOBJECT, XMLConstants.FLOAT_QNAME);
        sdoToXSDTypes.put(SDOConstants.SDO_INTOBJECT, XMLConstants.INT_QNAME);
        sdoToXSDTypes.put(SDOConstants.SDO_LONGOBJECT, XMLConstants.LONG_QNAME);
        sdoToXSDTypes.put(SDOConstants.SDO_SHORTOBJECT, XMLConstants.SHORT_QNAME);
    }

    private static void initXsdToSDOType() {
        xsdToSDOType.put(XMLConstants.ANY_SIMPLE_TYPE_QNAME, SDOConstants.SDO_OBJECT);
        xsdToSDOType.put(SDOConstants.ANY_TYPE_QNAME, SDOConstants.SDO_DATAOBJECT);
        xsdToSDOType.put(SDOConstants.ANY_URI_QNAME, SDOConstants.SDO_URI);
        xsdToSDOType.put(XMLConstants.BASE_64_BINARY_QNAME, SDOConstants.SDO_BYTES);
        xsdToSDOType.put(XMLConstants.BOOLEAN_QNAME, SDOConstants.SDO_BOOLEAN);
        xsdToSDOType.put(XMLConstants.BYTE_QNAME, SDOConstants.SDO_BYTE);
        xsdToSDOType.put(XMLConstants.DATE_QNAME, SDOConstants.SDO_YEARMONTHDAY);
        xsdToSDOType.put(XMLConstants.DATE_TIME_QNAME, SDOConstants.SDO_DATETIME);
        xsdToSDOType.put(XMLConstants.DECIMAL_QNAME, SDOConstants.SDO_DECIMAL);
        xsdToSDOType.put(XMLConstants.DOUBLE_QNAME, SDOConstants.SDO_DOUBLE);
        xsdToSDOType.put(SDOConstants.DURATION_QNAME, SDOConstants.SDO_DURATION);
        xsdToSDOType.put(SDOConstants.ENTITIES_QNAME, SDOConstants.SDO_STRINGS);
        xsdToSDOType.put(SDOConstants.ENTITY_QNAME, SDOConstants.SDO_STRING);
        xsdToSDOType.put(XMLConstants.FLOAT_QNAME, SDOConstants.SDO_FLOAT);
        xsdToSDOType.put(SDOConstants.GDAY_QNAME, SDOConstants.SDO_DAY);
        xsdToSDOType.put(SDOConstants.GMONTH_QNAME, SDOConstants.SDO_MONTH);
        xsdToSDOType.put(SDOConstants.GMONTHDAY_QNAME, SDOConstants.SDO_MONTHDAY);
        xsdToSDOType.put(SDOConstants.GYEAR_QNAME, SDOConstants.SDO_YEAR);
        xsdToSDOType.put(SDOConstants.GYEARMONTH_QNAME, SDOConstants.SDO_YEARMONTH);
        xsdToSDOType.put(XMLConstants.HEX_BINARY_QNAME, SDOConstants.SDO_BYTES);
        xsdToSDOType.put(SDOConstants.ID_QNAME, SDOConstants.SDO_STRING);
        xsdToSDOType.put(SDOConstants.IDREF_QNAME, SDOConstants.SDO_STRING);
        xsdToSDOType.put(SDOConstants.IDREFS_QNAME, SDOConstants.SDO_STRINGS);
        xsdToSDOType.put(XMLConstants.INT_QNAME, SDOConstants.SDO_INT);
        xsdToSDOType.put(XMLConstants.INTEGER_QNAME, SDOConstants.SDO_INTEGER);
        xsdToSDOType.put(SDOConstants.LANGUAGE_QNAME, SDOConstants.SDO_STRING);
        xsdToSDOType.put(XMLConstants.LONG_QNAME, SDOConstants.SDO_LONG);
        xsdToSDOType.put(SDOConstants.NAME_QNAME, SDOConstants.SDO_STRING);
        xsdToSDOType.put(SDOConstants.NCNAME_QNAME, SDOConstants.SDO_STRING);
        xsdToSDOType.put(SDOConstants.NEGATIVEINTEGER_QNAME, SDOConstants.SDO_INTEGER);
        xsdToSDOType.put(SDOConstants.NMTOKEN_QNAME, SDOConstants.SDO_STRING);
        xsdToSDOType.put(SDOConstants.NMTOKENS_QNAME, SDOConstants.SDO_STRINGS);
        xsdToSDOType.put(SDOConstants.NONNEGATIVEINTEGER_QNAME, SDOConstants.SDO_INTEGER);
        xsdToSDOType.put(SDOConstants.NONPOSITIVEINTEGER_QNAME, SDOConstants.SDO_INTEGER);
        xsdToSDOType.put(SDOConstants.NORMALIZEDSTRING_QNAME, SDOConstants.SDO_STRING);
        xsdToSDOType.put(SDOConstants.NOTATION_QNAME, SDOConstants.SDO_STRING);
        xsdToSDOType.put(SDOConstants.POSITIVEINTEGER_QNAME, SDOConstants.SDO_INTEGER);
        xsdToSDOType.put(XMLConstants.QNAME_QNAME, SDOConstants.SDO_URI);
        xsdToSDOType.put(XMLConstants.SHORT_QNAME, SDOConstants.SDO_SHORT);
        xsdToSDOType.put(XMLConstants.STRING_QNAME, SDOConstants.SDO_STRING);
        xsdToSDOType.put(XMLConstants.TIME_QNAME, SDOConstants.SDO_TIME);
        xsdToSDOType.put(SDOConstants.TOKEN_QNAME, SDOConstants.SDO_STRING);
        xsdToSDOType.put(XMLConstants.UNSIGNED_BYTE_QNAME, SDOConstants.SDO_SHORT);
        xsdToSDOType.put(XMLConstants.UNSIGNED_INT_QNAME, SDOConstants.SDO_LONG);
        xsdToSDOType.put(SDOConstants.UNSIGNEDLONG_QNAME, SDOConstants.SDO_INTEGER);
        xsdToSDOType.put(XMLConstants.UNSIGNED_SHORT_QNAME, SDOConstants.SDO_INT);
    }

    private static void initSDOTypeForSimpleJavaTypeMap() {
        sdoTypeForSimpleJavaType.put(ClassConstants.STRING, SDOConstants.SDO_STRING);
        sdoTypeForSimpleJavaType.put(ClassConstants.BOOLEAN, SDOConstants.SDO_BOOLEANOBJECT);
        sdoTypeForSimpleJavaType.put(ClassConstants.PBOOLEAN, SDOConstants.SDO_BOOLEAN);
        sdoTypeForSimpleJavaType.put(ClassConstants.BYTE, SDOConstants.SDO_BYTEOBJECT);
        sdoTypeForSimpleJavaType.put(ClassConstants.PBYTE, SDOConstants.SDO_BYTE);
        sdoTypeForSimpleJavaType.put(ClassConstants.ABYTE, SDOConstants.SDO_BYTES);
        sdoTypeForSimpleJavaType.put(ClassConstants.APBYTE, SDOConstants.SDO_BYTES);
        sdoTypeForSimpleJavaType.put(ClassConstants.CHAR, SDOConstants.SDO_CHARACTEROBJECT);
        sdoTypeForSimpleJavaType.put(ClassConstants.PCHAR, SDOConstants.SDO_CHARACTER);
        sdoTypeForSimpleJavaType.put(ClassConstants.BIGDECIMAL, SDOConstants.SDO_DECIMAL);
        sdoTypeForSimpleJavaType.put(ClassConstants.UTILDATE, SDOConstants.SDO_DATE);
        sdoTypeForSimpleJavaType.put(ClassConstants.DOUBLE, SDOConstants.SDO_DOUBLEOBJECT);
        sdoTypeForSimpleJavaType.put(ClassConstants.PDOUBLE, SDOConstants.SDO_DOUBLE);
        sdoTypeForSimpleJavaType.put(ClassConstants.FLOAT, SDOConstants.SDO_FLOATOBJECT);
        sdoTypeForSimpleJavaType.put(ClassConstants.PFLOAT, SDOConstants.SDO_FLOAT);
        sdoTypeForSimpleJavaType.put(ClassConstants.INTEGER, SDOConstants.SDO_INTOBJECT);
        sdoTypeForSimpleJavaType.put(ClassConstants.PINT, SDOConstants.SDO_INT);
        sdoTypeForSimpleJavaType.put(ClassConstants.BIGINTEGER, SDOConstants.SDO_INTEGER);
        sdoTypeForSimpleJavaType.put(ClassConstants.LONG, SDOConstants.SDO_LONGOBJECT);
        sdoTypeForSimpleJavaType.put(ClassConstants.PLONG, SDOConstants.SDO_LONG);
        sdoTypeForSimpleJavaType.put(ClassConstants.SHORT, SDOConstants.SDO_SHORTOBJECT);
        sdoTypeForSimpleJavaType.put(ClassConstants.PSHORT, SDOConstants.SDO_SHORT);
    }

    public Class getJavaWrapperTypeForSDOType(Type sdoType) {
        if (sdoType.getInstanceClass() != null) {
            return sdoType.getInstanceClass();
        }
        Class javaClass = null;
        if (sdoType.getBaseTypes() != null) {
            for (int i = 0; i < sdoType.getBaseTypes().size(); ++i) {
                Type baseType = (Type)sdoType.getBaseTypes().get(i);
                javaClass = this.getJavaWrapperTypeForSDOType(baseType);
                if (javaClass == null) continue;
                return javaClass;
            }
        }
        return javaClass;
    }

    public Type getType(String uri, String typeName) {
        if (typeName == null) {
            return null;
        }
        if (uri != null && uri.equals("commonj.sdo")) {
            return (Type)commonjHashMap.get(typeName);
        }
        if (uri != null && uri.equals("commonj.sdo/java")) {
            return (Type)commonjJavaHashMap.get(typeName);
        }
        QName qName = new QName(uri, typeName);
        return (Type)this.getTypesHashMap().get(qName);
    }

    public void addType(Type newType) {
        String uri = newType.getURI();
        String name = newType.getName();
        this.addType(uri, name, newType);
    }

    private void addType(String uri, String name, Type newType) {
        if (uri != null && uri.equals("commonj.sdo")) {
            commonjHashMap.put(name, newType);
        } else if (uri != null && uri.equals("commonj.sdo/java")) {
            commonjJavaHashMap.put(name, newType);
        } else {
            QName qName = new QName(uri, name);
            this.getTypesHashMap().put(qName, newType);
        }
    }

    public Type getType(Class interfaceClass) {
        for (QName key : this.getTypesHashMap().keySet()) {
            Type value = (Type)this.getTypesHashMap().get(key);
            if (value.getInstanceClass() != interfaceClass) continue;
            return value;
        }
        return null;
    }

    public Type getTypeForSimpleJavaType(Class implClass) {
        return (Type)SDOTypeHelperDelegate.getSDOTypeForSimpleJavaTypeMap().get(implClass);
    }

    public synchronized Type define(DataObject dataObject) {
        ArrayList types = new ArrayList();
        Type rootType = this.define(dataObject, types);
        this.initializeTypes(types);
        return rootType;
    }

    private void initializeTypes(List types) {
        SDOType nextType;
        int i;
        ArrayList<SDOType> descriptorsToAdd = new ArrayList<SDOType>(types);
        for (i = 0; i < types.size(); ++i) {
            nextType = (SDOType)types.get(i);
            if (nextType.isDataType()) continue;
            nextType.postInitialize();
        }
        for (i = 0; i < types.size(); ++i) {
            nextType = (SDOType)types.get(i);
            if ((!nextType.isDataType() && nextType.getBaseTypes() == null || nextType.getBaseTypes().size() == 0) && nextType.getSubTypes().size() > 0) {
                nextType.setupInheritance(null);
                continue;
            }
            if (nextType.isDataType() || nextType.getBaseTypes().size() <= 0 || types.contains(nextType.getBaseTypes().get(0))) continue;
            SDOType baseType = (SDOType)nextType.getBaseTypes().get(0);
            while (baseType != null && !baseType.isDataType()) {
                descriptorsToAdd.add(baseType);
                if (baseType.getBaseTypes().size() == 0) {
                    descriptorsToAdd.add(baseType);
                    baseType.setupInheritance(null);
                    baseType = null;
                    continue;
                }
                baseType = (SDOType)baseType.getBaseTypes().get(0);
            }
        }
        ((SDOXMLHelper)this.aHelperContext.getXMLHelper()).addDescriptors(descriptorsToAdd);
    }

    public synchronized Type define(DataObject dataObject, List types) {
        SDOTypeHelper typeHelper = (SDOTypeHelper)this.aHelperContext.getTypeHelper();
        if (dataObject == null || dataObject.getType() == null || !dataObject.getType().getURI().equals("commonj.sdo") || !dataObject.getType().getName().equals("Type")) {
            throw new IllegalArgumentException(SDOException.errorDefiningType());
        }
        String uri = dataObject.getString("uri");
        String name = dataObject.getString("name");
        if (name == null) {
            throw new IllegalArgumentException(SDOException.errorDefiningTypeNoName());
        }
        SDOType type = (SDOType)typeHelper.getType(uri, name);
        if (type != null) {
            return type;
        }
        type = new SDOType(uri, name, this.aHelperContext);
        this.addType(uri, name, type);
        types.add(type);
        type.setSequenced(dataObject.getBoolean("sequenced"));
        type.setAbstract(dataObject.getBoolean("abstract"));
        type.setDataType(dataObject.getBoolean("dataType"));
        List baseTypes = dataObject.getList("baseType");
        for (int i = 0; i < baseTypes.size(); ++i) {
            SDOType baseType = (SDOType)this.getValueFromObject(baseTypes.get(i), types);
            type.addBaseType(baseType);
        }
        List aliasNames = dataObject.getList("aliasName");
        for (int i = 0; i < aliasNames.size(); ++i) {
            Object aliasName = aliasNames.get(i);
            type.getAliasNames().add(aliasName);
        }
        List openProps = ((SDODataObject)dataObject)._getOpenContentProperties();
        for (int i = 0; i < openProps.size(); ++i) {
            SDOProperty nextProp = (SDOProperty)openProps.get(i);
            Object value = this.getValueFromObject(dataObject.get((Property)nextProp), types);
            type.setInstanceProperty(nextProp, value);
        }
        List openPropsAttrs = ((SDODataObject)dataObject)._getOpenContentPropertiesAttributes();
        for (int i = 0; i < openPropsAttrs.size(); ++i) {
            SDOProperty nextProp = (SDOProperty)openPropsAttrs.get(i);
            Object value = this.getValueFromObject(dataObject.get((Property)nextProp), types);
            type.setInstanceProperty(nextProp, value);
        }
        List properties = dataObject.getList("property");
        for (int i = 0; i < properties.size(); ++i) {
            Object nextValue = properties.get(i);
            if (!(nextValue instanceof DataObject)) continue;
            this.buildPropertyFromDataObject((DataObject)nextValue, type, types);
        }
        type.setOpen(dataObject.getBoolean("open"));
        if (!type.isDataType()) {
            type.preInitialize(null, null);
        }
        return type;
    }

    private boolean isBaseTypeBytes(Type theType) {
        List baseTypes = theType.getBaseTypes();
        if (baseTypes.size() > 0) {
            Type nextType = (Type)baseTypes.get(0);
            if (nextType == SDOConstants.SDO_BYTES) {
                return true;
            }
            return this.isBaseTypeBytes(nextType);
        }
        return false;
    }

    private Object getValueFromObject(Object objectValue, List types) {
        if (objectValue instanceof DataObject && ((DataObject)objectValue).getType() == SDOConstants.SDO_TYPE) {
            return this.define((DataObject)objectValue, types);
        }
        return objectValue;
    }

    private SDOProperty buildPropertyFromDataObject(DataObject dataObject, Type containingType, List types) {
        String nameValue = dataObject.getString("name");
        Object typeObjectValue = dataObject.get("type");
        SDOProperty newProperty = new SDOProperty(this.aHelperContext);
        newProperty.setName(nameValue);
        Type typeValue = (Type)this.getValueFromObject(typeObjectValue, types);
        newProperty.setType(typeValue);
        if (typeValue != null) {
            if (typeValue == SDOConstants.SDO_BYTES) {
                newProperty.setXsdType(XMLConstants.BASE_64_BINARY_QNAME);
            } else if (typeValue.isDataType() && this.isBaseTypeBytes(typeValue)) {
                newProperty.setXsdType(XMLConstants.BASE_64_BINARY_QNAME);
            }
        }
        if (dataObject.isSet("containment")) {
            newProperty.setContainment(dataObject.getBoolean("containment"));
        } else if (typeValue != null) {
            newProperty.setContainment(!typeValue.isDataType());
        }
        newProperty.setReadOnly(dataObject.getBoolean("readOnly"));
        newProperty.setMany(dataObject.getBoolean("many"));
        newProperty.setNullable(dataObject.getBoolean("nullable"));
        List aliasNames = dataObject.getList("aliasName");
        for (int i = 0; i < aliasNames.size(); ++i) {
            Object aliasName = aliasNames.get(i);
            newProperty.getAliasNames().add(aliasName);
        }
        Object opposite = dataObject.get("opposite");
        if (opposite != null && opposite instanceof Property) {
            newProperty.setOpposite((Property)opposite);
        }
        if (dataObject.isSet("default")) {
            newProperty.setDefault(dataObject.get("default"));
        }
        List openProps = ((SDODataObject)dataObject)._getOpenContentProperties();
        for (int i = 0; i < openProps.size(); ++i) {
            SDOProperty nextProp = (SDOProperty)openProps.get(i);
            Object value = this.getValueFromObject(dataObject.get((Property)nextProp), types);
            newProperty.setInstanceProperty(nextProp, value);
        }
        List openPropsAttrs = ((SDODataObject)dataObject)._getOpenContentPropertiesAttributes();
        for (int i = 0; i < openPropsAttrs.size(); ++i) {
            SDOProperty nextProp = (SDOProperty)openPropsAttrs.get(i);
            Object value = this.getValueFromObject(dataObject.get((Property)nextProp), types);
            newProperty.setInstanceProperty(nextProp, value);
        }
        if (newProperty.getType() == null) {
            throw SDOException.noTypeSpecifiedForProperty(newProperty.getName());
        }
        if (containingType != null) {
            ((SDOType)containingType).addDeclaredProperty(newProperty);
            if (this.aHelperContext.getXSDHelper().isElement((Property)newProperty)) {
                newProperty.setNamespaceQualified(true);
            }
            newProperty.buildMapping(containingType.getURI());
        }
        return newProperty;
    }

    public synchronized List define(List types) {
        ArrayList<Type> definedTypes = new ArrayList<Type>();
        for (int i = 0; i < types.size(); ++i) {
            Type definedType = this.define((DataObject)types.get(i));
            definedTypes.add(definedType);
        }
        return definedTypes;
    }

    public QName getXSDTypeFromSDOType(Type aType) {
        return (QName)sdoToXSDTypes.get(aType);
    }

    public SDOType getSDOTypeFromXSDType(QName aName) {
        return (SDOType)xsdToSDOType.get(aName);
    }

    public void setTypesHashMap(Map typesHashMap) {
        this.typesHashMap = typesHashMap;
    }

    public Map getTypesHashMap() {
        if (this.typesHashMap == null) {
            this.initTypesHashMap();
        }
        return this.typesHashMap;
    }

    public void reset() {
        this.initTypesHashMap();
        this.namespaceResolver = new NamespaceResolver();
        this.initOpenProps();
        SDOConstants.SDO_OPEN_SEQUENCED.getXmlDescriptor().setNamespaceResolver(null);
    }

    public Property defineOpenContentProperty(String uri, DataObject propertyDO) {
        String name = propertyDO.getString("name");
        Property propertyToReturn = this.aHelperContext.getXSDHelper().getGlobalProperty(uri, name, true);
        if (propertyToReturn == null) {
            propertyToReturn = this.aHelperContext.getXSDHelper().getGlobalProperty(uri, name, false);
        }
        if (propertyToReturn == null || !(propertyToReturn instanceof Property)) {
            ArrayList types = new ArrayList();
            propertyToReturn = this.buildPropertyFromDataObject(propertyDO, null, types);
            this.initializeTypes(types);
            this.defineOpenContentProperty(uri, name, propertyToReturn);
        }
        return propertyToReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void defineOpenContentProperty(String propertyUri, String propertyName, Property property) {
        if (propertyUri != null) {
            QName propertyQName = new QName(propertyUri, propertyName);
            this.openContentProperties.put(propertyQName, property);
            boolean isElement = this.aHelperContext.getXSDHelper().isElement(property);
            ((SDOXSDHelper)this.aHelperContext.getXSDHelper()).addGlobalProperty(propertyQName, property, isElement);
            ((SDOProperty)property).setUri(propertyUri);
            XMLDescriptor aDescriptor = ((SDOType)property.getType()).getXmlDescriptor();
            if (aDescriptor != null) {
                XMLDescriptor xMLDescriptor = aDescriptor;
                synchronized (xMLDescriptor) {
                    String rootName = propertyName;
                    String prefix = aDescriptor.getNonNullNamespaceResolver().resolveNamespaceURI(propertyUri);
                    if (prefix == null || prefix.equals("")) {
                        prefix = ((SDOTypeHelper)this.aHelperContext.getTypeHelper()).getPrefix(propertyUri);
                        aDescriptor.getNonNullNamespaceResolver().put(prefix, propertyUri);
                    }
                    if (prefix != null && !prefix.equals("")) {
                        rootName = prefix + ":" + rootName;
                    }
                    aDescriptor.setDefaultRootElement(rootName);
                    QName elementType = new QName(propertyUri, rootName);
                    aDescriptor.setDefaultRootElementType(elementType);
                    ((SDOXMLHelper)this.aHelperContext.getXMLHelper()).getXmlContext().storeXMLDescriptorByQName(aDescriptor);
                }
            }
        }
    }

    public Property getOpenContentProperty(String uri, String propertyName) {
        QName qname = new QName(uri, propertyName);
        return (Property)this.openContentProperties.get(qname);
    }

    private static Map getSDOTypeForSimpleJavaTypeMap() {
        return sdoTypeForSimpleJavaType;
    }

    public HelperContext getHelperContext() {
        return this.aHelperContext;
    }

    public void setHelperContext(HelperContext helperContext) {
        this.aHelperContext = helperContext;
    }

    public String getPrefix(String uri) {
        if (uri == null) {
            return null;
        }
        NamespaceResolver nr = this.getNamespaceResolver();
        String existingPrefixForUri = nr.resolveNamespaceURI(uri);
        if (existingPrefixForUri == null || existingPrefixForUri.equals("")) {
            String newPrefix = this.generatePrefix(uri);
            nr.put(newPrefix, uri);
            return newPrefix;
        }
        return existingPrefixForUri;
    }

    private String generatePrefix(String uri) {
        NamespaceResolver nr = this.getNamespaceResolver();
        if (uri.equals("commonj.sdo")) {
            return nr.generatePrefix("sdo");
        }
        if (uri.equals("commonj.sdo/xml")) {
            return nr.generatePrefix("sdoXML");
        }
        if (uri.equals("commonj.sdo/java")) {
            return nr.generatePrefix("sdoJava");
        }
        return nr.generatePrefix();
    }

    public String addNamespace(String prefix, String uri) {
        NamespaceResolver nr = this.getNamespaceResolver();
        String existingPrefixForURI = nr.resolveNamespaceURI(uri);
        if (existingPrefixForURI != null && !existingPrefixForURI.equals("")) {
            return existingPrefixForURI;
        }
        String existingUriForPrefix = nr.resolveNamespacePrefix(prefix);
        if (existingUriForPrefix == null) {
            nr.put(prefix, uri);
            return prefix;
        }
        prefix = this.generatePrefix(uri);
        nr.put(prefix, uri);
        return prefix;
    }

    public NamespaceResolver getNamespaceResolver() {
        if (this.namespaceResolver == null) {
            this.namespaceResolver = new NamespaceResolver();
        }
        return this.namespaceResolver;
    }

    public Map getOpenContentProperties() {
        return this.openContentProperties;
    }

    private void initOpenProps() {
        this.openContentProperties = new HashMap();
        this.openContentProperties.put(SDOConstants.MIME_TYPE_QNAME, SDOConstants.MIME_TYPE_PROPERTY);
        this.openContentProperties.put(SDOConstants.MIME_TYPE_PROPERTY_QNAME, SDOConstants.MIME_TYPE_PROPERTY_PROPERTY);
        this.openContentProperties.put(SDOConstants.SCHEMA_TYPE_QNAME, SDOConstants.XML_SCHEMA_TYPE_PROPERTY);
        this.openContentProperties.put(SDOConstants.JAVA_CLASS_QNAME, SDOConstants.JAVA_CLASS_PROPERTY);
        this.openContentProperties.put(SDOConstants.XML_ELEMENT_QNAME, SDOConstants.XMLELEMENT_PROPERTY);
        this.openContentProperties.put(SDOConstants.XML_DATATYPE_QNAME, SDOConstants.XMLDATATYPE_PROPERTY);
        this.openContentProperties.put(SDOConstants.XML_ID_PROPERTY_QNAME, SDOConstants.ID_PROPERTY);
        this.openContentProperties.put(SDOConstants.DOCUMENTATION_PROPERTY_QNAME, SDOConstants.DOCUMENTATION_PROPERTY);
    }

    static {
        SDOTypeHelperDelegate.initCommonjHashMap();
        SDOTypeHelperDelegate.initCommonjJavaHashMap();
        SDOTypeHelperDelegate.initXsdToSDOType();
        SDOTypeHelperDelegate.initSdoToXSDType();
        SDOTypeHelperDelegate.initSDOTypeForSimpleJavaTypeMap();
    }
}

